/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.SslServerTlsHandler;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.ScopeModel;

public class NettyServer
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(NettyServer.class);
    private Map<String, Channel> channels;
    private ServerBootstrap bootstrap;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final int serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getUrl().getOrDefaultModuleModel());

    public NettyServer(URL url, ChannelHandler handler) throws RemotingException {
        super(ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler"), ChannelHandlers.wrap((ChannelHandler)handler, (URL)url));
    }

    protected void doOpen() throws Throwable {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup((int)1, (String)"NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup((int)this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), (String)"NettyServerWorker");
        final NettyServerHandler nettyServerHandler = new NettyServerHandler(this.getUrl(), (ChannelHandler)this);
        this.channels = nettyServerHandler.getChannels();
        boolean keepalive = this.getUrl().getParameter("keep.alive", Boolean.FALSE.booleanValue());
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.SO_KEEPALIVE, (Object)keepalive).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int idleTimeout = UrlUtils.getIdleTimeout((URL)NettyServer.this.getUrl());
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyServer.this.getCodec(), NettyServer.this.getUrl(), (ChannelHandler)NettyServer.this);
                if (NettyServer.this.getUrl().getParameter("ssl-enabled", false)) {
                    ch.pipeline().addLast("negotiation", (io.netty.channel.ChannelHandler)new SslServerTlsHandler(NettyServer.this.getUrl()));
                }
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("server-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS)).addLast("handler", (io.netty.channel.ChannelHandler)nettyServerHandler);
            }
        });
        ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)this.getBindAddress());
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    protected void doClose() throws Throwable {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (this.bootstrap != null) {
                long timeout = this.serverShutdownTimeoutMills;
                long quietPeriod = Math.min(2000L, timeout);
                Future bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.syncUninterruptibly();
                workerGroupShutdownFuture.syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public Collection<Channel> getChannels() {
        ArrayList<Channel> chs = new ArrayList<Channel>(this.channels.size());
        chs.addAll(this.channels.values());
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public boolean canHandleIdle() {
        return true;
    }

    public boolean isBound() {
        return this.channel.isActive();
    }
}

