/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class SslContexts {
    private static final Logger logger = LoggerFactory.getLogger(SslContexts.class);

    public static SslContext buildServerSslContext(URL url) {
        ConfigManager globalConfigManager = ApplicationModel.getConfigManager();
        SslConfig sslConfig = (SslConfig)globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder sslClientContextBuilder = null;
        InputStream serverKeyCertChainPathStream = null;
        InputStream serverPrivateKeyPathStream = null;
        InputStream serverTrustCertStream = null;
        try {
            serverKeyCertChainPathStream = sslConfig.getServerKeyCertChainPathStream();
            serverPrivateKeyPathStream = sslConfig.getServerPrivateKeyPathStream();
            serverTrustCertStream = sslConfig.getServerTrustCertCollectionPathStream();
            String password = sslConfig.getServerKeyPassword();
            sslClientContextBuilder = password != null ? SslContextBuilder.forServer((InputStream)serverKeyCertChainPathStream, (InputStream)serverPrivateKeyPathStream, (String)password) : SslContextBuilder.forServer((InputStream)serverKeyCertChainPathStream, (InputStream)serverPrivateKeyPathStream);
            if (serverTrustCertStream != null) {
                sslClientContextBuilder.trustManager(serverTrustCertStream);
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
            if (sslConfig.getCiphers() != null) {
                sslClientContextBuilder.ciphers((Iterable)sslConfig.getCiphers());
            }
            if (sslConfig.getProtocols() != null) {
                sslClientContextBuilder.protocols((Iterable)sslConfig.getProtocols());
            }
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", e);
            }
            catch (Throwable throwable) {
                SslContexts.safeCloseStream(serverKeyCertChainPathStream);
                SslContexts.safeCloseStream(serverPrivateKeyPathStream);
                SslContexts.safeCloseStream(serverTrustCertStream);
                throw throwable;
            }
        }
        SslContexts.safeCloseStream(serverKeyCertChainPathStream);
        SslContexts.safeCloseStream(serverPrivateKeyPathStream);
        SslContexts.safeCloseStream(serverTrustCertStream);
        try {
            return sslClientContextBuilder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    public static SslContext buildClientSslContext(URL url) {
        ConfigManager globalConfigManager = ApplicationModel.getConfigManager();
        SslConfig sslConfig = (SslConfig)globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder builder = SslContextBuilder.forClient();
        InputStream clientTrustCertCollectionPath = null;
        InputStream clientCertChainFilePath = null;
        InputStream clientPrivateKeyFilePath = null;
        try {
            clientTrustCertCollectionPath = sslConfig.getClientTrustCertCollectionPathStream();
            if (clientTrustCertCollectionPath != null) {
                builder.trustManager(clientTrustCertCollectionPath);
            }
            clientCertChainFilePath = sslConfig.getClientKeyCertChainPathStream();
            clientPrivateKeyFilePath = sslConfig.getClientPrivateKeyPathStream();
            if (clientCertChainFilePath != null && clientPrivateKeyFilePath != null) {
                String password = sslConfig.getClientKeyPassword();
                if (password != null) {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath, password);
                } else {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath);
                }
            }
            if (sslConfig.getCiphers() != null) {
                builder.ciphers((Iterable)sslConfig.getCiphers());
            }
            if (sslConfig.getProtocols() != null) {
                builder.protocols((Iterable)sslConfig.getProtocols());
            }
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("Could not find certificate file or find invalid certificate.", e);
            }
            catch (Throwable throwable) {
                SslContexts.safeCloseStream(clientTrustCertCollectionPath);
                SslContexts.safeCloseStream(clientCertChainFilePath);
                SslContexts.safeCloseStream(clientPrivateKeyFilePath);
                throw throwable;
            }
        }
        SslContexts.safeCloseStream(clientTrustCertCollectionPath);
        SslContexts.safeCloseStream(clientCertChainFilePath);
        SslContexts.safeCloseStream(clientPrivateKeyFilePath);
        try {
            return builder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    private static SslProvider findSslProvider() {
        if (OpenSsl.isAvailable()) {
            logger.info("Using OPENSSL provider.");
            return SslProvider.OPENSSL;
        }
        if (SslContexts.checkJdkProvider()) {
            logger.info("Using JDK provider.");
            return SslProvider.JDK;
        }
        throw new IllegalStateException("Could not find any valid TLS provider, please check your dependency or deployment environment, usually netty-tcnative, Conscrypt, or Jetty NPN/ALPN is needed.");
    }

    private static boolean checkJdkProvider() {
        Provider[] jdkProviders = Security.getProviders("SSLContext.TLS");
        return jdkProviders != null && jdkProviders.length > 0;
    }

    private static void safeCloseStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a stream.", (Throwable)e);
        }
    }
}

