/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpChannelFutureListener;

public class NettyHttp3StreamChannel
implements H2StreamChannel {
    private final QuicStreamChannel http3StreamChannel;

    public NettyHttp3StreamChannel(QuicStreamChannel http3StreamChannel) {
        this.http3StreamChannel = http3StreamChannel;
    }

    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.close().addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    public Http2OutputMessage newOutputMessage(boolean endStream) {
        ByteBuf buffer = this.http3StreamChannel.alloc().buffer();
        return new Http2OutputMessageFrame((OutputStream)new ByteBufOutputStream(buffer), endStream);
    }

    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.write((Object)httpMetadata).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        NettyHttpChannelFutureListener futureListener = new NettyHttpChannelFutureListener();
        this.http3StreamChannel.write((Object)httpOutputMessage).addListener((GenericFutureListener)futureListener);
        return futureListener;
    }

    public SocketAddress remoteAddress() {
        return this.http3StreamChannel.parent().remoteSocketAddress();
    }

    public SocketAddress localAddress() {
        return this.http3StreamChannel.parent().localSocketAddress();
    }

    public void flush() {
        this.http3StreamChannel.flush();
    }
}

