/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http3.DefaultHttp3DataFrame;
import io.netty.handler.codec.http3.DefaultHttp3Headers;
import io.netty.handler.codec.http3.DefaultHttp3HeadersFrame;
import io.netty.handler.codec.http3.Http3DataFrame;
import io.netty.handler.codec.http3.Http3Headers;
import io.netty.handler.codec.http3.Http3HeadersFrame;
import io.netty.handler.codec.http3.Http3RequestStreamInboundHandler;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.message.DefaultHttpHeaders;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.remoting.http3.netty4.Constants;

@ChannelHandler.Sharable
public class NettyHttp3FrameCodec
extends Http3RequestStreamInboundHandler
implements ChannelOutboundHandler {
    public static final NettyHttp3FrameCodec INSTANCE = new NettyHttp3FrameCodec();

    protected void channelRead(ChannelHandlerContext ctx, Http3HeadersFrame frame) {
        Http3Headers headers = frame.headers();
        if (headers.contains((Object)Constants.TRI_PING)) {
            this.pingReceived(ctx);
            return;
        }
        ctx.fireChannelRead((Object)new Http2MetadataFrame(NettyHttp3FrameCodec.getStreamId(ctx), (HttpHeaders)new DefaultHttpHeaders((Headers)headers), false));
    }

    private void pingReceived(ChannelHandlerContext ctx) {
        DefaultHttp3Headers pongHeader = new DefaultHttp3Headers(false);
        pongHeader.set((Object)Constants.TRI_PING, (Object)"0");
        pongHeader.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)HttpStatus.OK.getStatusString());
        ChannelFuture future = ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)pongHeader), ctx.newPromise());
        if (future.isDone()) {
            ctx.close();
        } else {
            future.addListener((GenericFutureListener)((ChannelFutureListener)f -> ctx.close()));
        }
    }

    protected void channelRead(ChannelHandlerContext ctx, Http3DataFrame frame) {
        ctx.fireChannelRead((Object)new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), (InputStream)new ByteBufInputStream(frame.content(), true), false));
    }

    private static long getStreamId(ChannelHandlerContext ctx) {
        return ((QuicStreamChannel)ctx.channel()).streamId();
    }

    protected void channelInputClosed(ChannelHandlerContext ctx) {
        ctx.fireChannelRead((Object)new Http2InputMessageFrame(NettyHttp3FrameCodec.getStreamId(ctx), (InputStream)StreamUtils.EMPTY, true));
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2Header) {
            Http2Header headers = (Http2Header)msg;
            if (headers.isEndStream()) {
                ChannelFuture future = ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)((NettyHttpHeaders)headers.headers()).getHeaders()), ctx.newPromise());
                if (future.isDone()) {
                    ctx.close(promise);
                } else {
                    future.addListener((GenericFutureListener)((ChannelFutureListener)f -> ctx.close(promise)));
                }
                return;
            }
            ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)((NettyHttpHeaders)headers.headers()).getHeaders()), promise);
        } else if (msg instanceof Http2OutputMessage) {
            Http2OutputMessage message = (Http2OutputMessage)msg;
            OutputStream body = message.getBody();
            assert (body instanceof ByteBufOutputStream || body == null);
            if (message.isEndStream()) {
                if (body == null) {
                    ctx.close(promise);
                    return;
                }
                ChannelFuture future = ctx.write((Object)new DefaultHttp3DataFrame(((ByteBufOutputStream)body).buffer()), ctx.newPromise());
                if (future.isDone()) {
                    ctx.close(promise);
                } else {
                    future.addListener((GenericFutureListener)((ChannelFutureListener)f -> ctx.close(promise)));
                }
                return;
            }
            if (body == null) {
                promise.trySuccess();
                return;
            }
            ctx.write((Object)new DefaultHttp3DataFrame(((ByteBufOutputStream)body).buffer()), promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }
}

