/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameCodec;

public class NettyHttp2SettingsHandler
extends SimpleChannelInboundHandler<Http2SettingsFrame> {
    private static final Logger logger = LoggerFactory.getLogger(NettyHttp2SettingsHandler.class);
    private final Set<NettyHttp2FrameCodec> settingsFrameArrivalSubscribers = new HashSet<NettyHttp2FrameCodec>();
    private boolean settingsFrameArrived;

    protected void channelRead0(ChannelHandlerContext ctx, Http2SettingsFrame msg) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Receive client Http2 Settings frame of " + ctx.channel().localAddress() + " <- " + ctx.channel().remoteAddress());
        }
        this.settingsFrameArrived = true;
        for (NettyHttp2FrameCodec nettyHttp2FrameCodec : this.settingsFrameArrivalSubscribers) {
            nettyHttp2FrameCodec.notifySettingsFrameArrival();
        }
        this.settingsFrameArrivalSubscribers.clear();
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public boolean subscribeSettingsFrameArrival(NettyHttp2FrameCodec nettyHttp2FrameCodec) {
        if (!this.settingsFrameArrived) {
            this.settingsFrameArrivalSubscribers.add(nettyHttp2FrameCodec);
            return true;
        }
        return false;
    }

    public void unsubscribeSettingsFrameArrival(NettyHttp2FrameCodec nettyHttp2FrameCodec) {
        this.settingsFrameArrivalSubscribers.remove((Object)nettyHttp2FrameCodec);
    }
}

