/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.message.DefaultHttpHeaders;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2SettingsHandler;

public class NettyHttp2FrameCodec
extends ChannelDuplexHandler {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyHttp2FrameCodec.class);
    private static final long SETTINGS_FRAME_ARRIVAL_TIMEOUT = 3L;
    private final NettyHttp2SettingsHandler nettyHttp2SettingsHandler;
    private final List<CachedMsg> cachedMsgList = new LinkedList<CachedMsg>();
    private boolean settingsFrameArrived;
    private ScheduledFuture<?> settingsFrameArrivalTimeoutFuture;

    public NettyHttp2FrameCodec(NettyHttp2SettingsHandler nettyHttp2SettingsHandler) {
        this.nettyHttp2SettingsHandler = nettyHttp2SettingsHandler;
        if (!nettyHttp2SettingsHandler.subscribeSettingsFrameArrival(this)) {
            this.settingsFrameArrived = true;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            super.channelRead(ctx, (Object)this.onHttp2HeadersFrame((Http2HeadersFrame)msg));
        } else if (msg instanceof Http2DataFrame) {
            super.channelRead(ctx, (Object)this.onHttp2DataFrame((Http2DataFrame)msg));
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.settingsFrameArrived) {
            if (msg instanceof Http2Header) {
                super.write(ctx, (Object)this.encodeHttp2HeadersFrame((Http2Header)msg), promise);
            } else if (msg instanceof Http2OutputMessage) {
                super.write(ctx, (Object)this.encodeHttp2DataFrame((Http2OutputMessage)msg), promise);
            } else {
                super.write(ctx, msg, promise);
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache writing msg before client connection preface arrival: {}", new Object[]{msg});
        }
        this.cachedMsgList.add(new CachedMsg(ctx, msg, promise));
        if (this.settingsFrameArrivalTimeoutFuture == null) {
            this.settingsFrameArrivalTimeoutFuture = ctx.executor().schedule(() -> {
                LOGGER.error("4-13", "", "", "client connection preface does not arrive in time.");
                ctx.close();
                this.nettyHttp2SettingsHandler.unsubscribeSettingsFrameArrival(this);
                this.cachedMsgList.clear();
            }, 3L, TimeUnit.SECONDS);
        }
    }

    public void notifySettingsFrameArrival() throws Exception {
        if (this.settingsFrameArrived) {
            return;
        }
        this.settingsFrameArrived = true;
        if (this.settingsFrameArrivalTimeoutFuture != null) {
            this.settingsFrameArrivalTimeoutFuture.cancel(false);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin cached channel msg writing when client connection preface arrived.");
        }
        for (CachedMsg cached : this.cachedMsgList) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cached channel msg writing, ctx: {} msg: {}", new Object[]{cached.ctx, cached.msg});
            }
            if (cached.msg instanceof Http2Header) {
                super.write(cached.ctx, (Object)this.encodeHttp2HeadersFrame((Http2Header)cached.msg), cached.promise);
                continue;
            }
            if (cached.msg instanceof Http2OutputMessage) {
                super.write(cached.ctx, (Object)this.encodeHttp2DataFrame((Http2OutputMessage)cached.msg), cached.promise);
                continue;
            }
            super.write(cached.ctx, cached.msg, cached.promise);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("End cached channel msg writing.");
        }
        this.cachedMsgList.clear();
    }

    private Http2Header onHttp2HeadersFrame(Http2HeadersFrame headersFrame) {
        return new Http2MetadataFrame(headersFrame.stream().id(), new DefaultHttpHeaders((Headers<CharSequence, CharSequence, ?>)headersFrame.headers()), headersFrame.isEndStream());
    }

    private Http2InputMessage onHttp2DataFrame(Http2DataFrame dataFrame) {
        return new Http2InputMessageFrame(dataFrame.stream().id(), (InputStream)new ByteBufInputStream(dataFrame.content(), true), dataFrame.isEndStream());
    }

    private Http2HeadersFrame encodeHttp2HeadersFrame(Http2Header http2Header) {
        return new DefaultHttp2HeadersFrame((Http2Headers)((NettyHttpHeaders)http2Header.headers()).getHeaders(), http2Header.isEndStream());
    }

    private Http2DataFrame encodeHttp2DataFrame(Http2OutputMessage outputMessage) {
        OutputStream body = outputMessage.getBody();
        if (body == null) {
            return new DefaultHttp2DataFrame(outputMessage.isEndStream());
        }
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            return new DefaultHttp2DataFrame(buffer, outputMessage.isEndStream());
        }
        throw new IllegalArgumentException("Http2OutputMessage body must be ByteBufOutputStream");
    }

    private static class CachedMsg {
        private final ChannelHandlerContext ctx;
        private final Object msg;
        private final ChannelPromise promise;

        public CachedMsg(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            this.ctx = ctx;
            this.msg = msg;
            this.promise = promise;
        }
    }
}

