/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.CodecMediaType;

public interface HttpMessageDecoder
extends CodecMediaType {
    public Object decode(InputStream var1, Class<?> var2, Charset var3) throws DecodeException;

    default public Object decode(InputStream inputStream, Type targetType, Charset charset) throws DecodeException {
        if (targetType instanceof Class) {
            return this.decode(inputStream, (Class)targetType, charset);
        }
        if (targetType instanceof ParameterizedType) {
            return this.decode(inputStream, (Class)((ParameterizedType)targetType).getRawType(), charset);
        }
        throw new DecodeException("targetType " + targetType + " is not a class");
    }

    default public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        return new Object[]{this.decode(inputStream, ArrayUtils.isEmpty((Object[])targetTypes) ? null : targetTypes[0], charset)};
    }

    default public Object decode(InputStream inputStream, Class<?> targetType) throws DecodeException {
        return this.decode(inputStream, targetType, StandardCharsets.UTF_8);
    }

    default public Object decode(InputStream inputStream, Type targetType) throws DecodeException {
        return this.decode(inputStream, targetType, StandardCharsets.UTF_8);
    }

    default public Object[] decode(InputStream inputStream, Class<?>[] targetTypes) throws DecodeException {
        return this.decode(inputStream, targetTypes, StandardCharsets.UTF_8);
    }
}

