/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpHeaders;

public final class HttpHeadersMapAdapter
implements Map<String, List<String>> {
    private final HttpHeaders headers;

    public HttpHeadersMapAdapter(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof CharSequence && this.headers.containsKey((CharSequence)key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<CharSequence, String> entry : this.headers) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> get(Object key) {
        return key instanceof CharSequence ? this.headers.get((CharSequence)key) : Collections.emptyList();
    }

    @Override
    public List<String> put(String key, List<String> value) {
        List<String> all = this.headers.get(key);
        this.headers.set((CharSequence)key, value);
        return all;
    }

    @Override
    public List<String> remove(Object key) {
        return key instanceof CharSequence ? this.headers.remove((CharSequence)key) : Collections.emptyList();
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.set(m);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.names();
    }

    @Override
    public Collection<List<String>> values() {
        final Set<CharSequence> names = this.headers.nameSet();
        return new AbstractCollection<List<String>>(){

            @Override
            public Iterator<List<String>> iterator() {
                final Iterator it = names.iterator();
                return new Iterator<List<String>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public List<String> next() {
                        CharSequence next = (CharSequence)it.next();
                        return next == null ? Collections.emptyList() : HttpHeadersMapAdapter.this.headers.get(next);
                    }
                };
            }

            @Override
            public int size() {
                return names.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        final Set<CharSequence> names = this.headers.nameSet();
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                final Iterator it = names.iterator();
                return new Iterator<Map.Entry<String, List<String>>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, List<String>> next() {
                        final CharSequence next = (CharSequence)it.next();
                        return new Map.Entry<String, List<String>>(){

                            @Override
                            public String getKey() {
                                return next == null ? null : next.toString();
                            }

                            @Override
                            public List<String> getValue() {
                                return next == null ? Collections.emptyList() : HttpHeadersMapAdapter.this.get(next);
                            }

                            @Override
                            public List<String> setValue(List<String> value) {
                                if (next == null) {
                                    return Collections.emptyList();
                                }
                                Object values = HttpHeadersMapAdapter.this.get(next);
                                HttpHeadersMapAdapter.this.headers.set(next, value);
                                return values;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return names.size();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HttpHeadersMapAdapter && this.headers.equals(((HttpHeadersMapAdapter)obj).headers);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return "HttpHeadersMapAdapter{headers=" + this.headers + '}';
    }
}

