/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h2.command;

import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.command.DataQueueCommand;
import org.apache.dubbo.remoting.http12.command.HeaderQueueCommand;
import org.apache.dubbo.remoting.http12.command.HttpWriteQueue;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2ChannelDelegate;
import org.apache.dubbo.remoting.http12.h2.command.ResetQueueCommand;

public class Http2WriteQueueChannel
extends Http2ChannelDelegate {
    private final HttpWriteQueue httpWriteQueue;

    public Http2WriteQueueChannel(H2StreamChannel h2StreamChannel, HttpWriteQueue httpWriteQueue) {
        super(h2StreamChannel);
        this.httpWriteQueue = httpWriteQueue;
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        HeaderQueueCommand cmd = new HeaderQueueCommand(httpMetadata);
        cmd.setHttpChannel(this::getH2StreamChannel);
        return this.httpWriteQueue.enqueue(cmd);
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        DataQueueCommand cmd = new DataQueueCommand(httpOutputMessage);
        cmd.setHttpChannel(this::getH2StreamChannel);
        return this.httpWriteQueue.enqueue(cmd);
    }

    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        ResetQueueCommand cmd = new ResetQueueCommand(errorCode);
        cmd.setHttpChannel(this::getH2StreamChannel);
        return this.httpWriteQueue.enqueue(cmd);
    }
}

