/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h2;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.dubbo.remoting.http12.AbstractServerHttpChannelObserver;
import org.apache.dubbo.remoting.http12.ErrorCodeHolder;
import org.apache.dubbo.remoting.http12.FlowControlStreamObserver;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.h2.CancelStreamException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2CancelableStreamObserver;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.remoting.http12.netty4.NettyHttpHeaders;
import org.apache.dubbo.rpc.CancellationContext;

public class Http2ServerChannelObserver
extends AbstractServerHttpChannelObserver<H2StreamChannel>
implements FlowControlStreamObserver<Object>,
Http2CancelableStreamObserver<Object> {
    private CancellationContext cancellationContext;
    private StreamingDecoder streamingDecoder;
    private boolean autoRequestN = true;

    public Http2ServerChannelObserver(H2StreamChannel h2StreamChannel) {
        super(h2StreamChannel);
    }

    public void setStreamingDecoder(StreamingDecoder streamingDecoder) {
        this.streamingDecoder = streamingDecoder;
    }

    @Override
    protected HttpMetadata encodeHttpMetadata(boolean endStream) {
        NettyHttpHeaders<DefaultHttp2Headers> headers = new NettyHttpHeaders<DefaultHttp2Headers>(new DefaultHttp2Headers(false, 8));
        headers.set(HttpHeaderNames.TE.getKey(), "trailers");
        return new Http2MetadataFrame(headers, endStream);
    }

    @Override
    protected HttpMetadata encodeTrailers(Throwable throwable) {
        return new Http2MetadataFrame(new NettyHttpHeaders<DefaultHttp2Headers>(new DefaultHttp2Headers(false, 4)), true);
    }

    @Override
    public void setCancellationContext(CancellationContext cancellationContext) {
        this.cancellationContext = cancellationContext;
    }

    @Override
    public CancellationContext getCancellationContext() {
        return this.cancellationContext;
    }

    @Override
    public void cancel(Throwable throwable) {
        if (throwable instanceof CancelStreamException && ((CancelStreamException)throwable).isCancelByRemote()) {
            this.closed();
        }
        if (this.cancellationContext != null) {
            this.cancellationContext.cancel(throwable);
        }
        long errorCode = 0L;
        if (throwable instanceof ErrorCodeHolder) {
            errorCode = ((ErrorCodeHolder)((Object)throwable)).getErrorCode();
        }
        ((H2StreamChannel)this.getHttpChannel()).writeResetFrame(errorCode);
    }

    @Override
    public void request(int count) {
        this.streamingDecoder.request(count);
    }

    @Override
    public void disableAutoFlowControl() {
        this.autoRequestN = false;
    }

    @Override
    public boolean isAutoRequestN() {
        return this.autoRequestN;
    }

    @Override
    public void close() {
        super.close();
        this.streamingDecoder.onStreamClosed();
    }
}

