/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.exception;

import org.apache.dubbo.remoting.http12.HttpUtils;

public class HttpStatusException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;

    public HttpStatusException(int statusCode) {
        super(HttpUtils.getStatusMessage(statusCode));
        this.statusCode = statusCode;
    }

    public HttpStatusException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public HttpStatusException(int statusCode, Throwable cause) {
        super(HttpUtils.getStatusMessage(statusCode), cause);
        this.statusCode = statusCode;
    }

    public HttpStatusException(int statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getDisplayMessage() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": status=" + this.statusCode + ", " + this.getMessage();
    }
}

