/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.DecodeException;

public final class HttpUtils {
    public static final ByteBufAllocator HEAP_ALLOC = new UnpooledByteBufAllocator(false, false);
    public static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(16384L);
    public static final String CHARSET_PREFIX = "charset=";

    private HttpUtils() {
    }

    public static String getStatusMessage(int status) {
        return HttpResponseStatus.valueOf((int)status).reasonPhrase();
    }

    public static String toStatusString(int statusCode) {
        if (statusCode == 200) {
            return HttpStatus.OK.getStatusString();
        }
        if (statusCode == 500) {
            return HttpStatus.INTERNAL_SERVER_ERROR.getStatusString();
        }
        return Integer.toString(statusCode);
    }

    public static List<HttpCookie> decodeCookies(String value) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        for (Cookie c : ServerCookieDecoder.LAX.decodeAll(value)) {
            cookies.add(new HttpCookie(c.name(), c.value()));
        }
        return cookies;
    }

    public static String parseCharset(String contentType) {
        String charset = null;
        if (contentType == null) {
            charset = "";
        } else {
            int index = contentType.lastIndexOf(CHARSET_PREFIX);
            if (index == -1) {
                charset = "";
            } else {
                charset = contentType.substring(index + CHARSET_PREFIX.length()).trim();
                int splits = charset.indexOf(";");
                if (splits == -1) {
                    return charset;
                }
                return charset.substring(0, splits).trim();
            }
        }
        return charset;
    }

    public static String encodeCookie(HttpCookie cookie) {
        DefaultCookie c = new DefaultCookie(cookie.name(), cookie.value());
        c.setPath(cookie.path());
        c.setDomain(cookie.domain());
        c.setMaxAge(cookie.maxAge());
        c.setSecure(cookie.secure());
        c.setHttpOnly(cookie.httpOnly());
        c.setSameSite(CookieHeaderNames.SameSite.valueOf((String)cookie.sameSite()));
        return ServerCookieEncoder.LAX.encode((Cookie)c);
    }

    public static List<String> parseAccept(String header) {
        if (header == null) {
            return new ArrayList<String>();
        }
        ArrayList mediaTypes = new ArrayList();
        for (String item : StringUtils.tokenize((String)header, (char[])new char[]{','})) {
            int index = item.indexOf(59);
            mediaTypes.add(new Item<String>(StringUtils.substring((String)item, (int)0, (int)index), HttpUtils.parseQuality(item, index)));
        }
        return Item.sortAndGet(mediaTypes);
    }

    public static float parseQuality(String expr, int index) {
        int qStart;
        float quality = 1.0f;
        if (index != -1 && (qStart = expr.indexOf("q=", index + 1)) != -1) {
            int qEnd = expr.indexOf(44, qStart += 2);
            String qString = qEnd == -1 ? expr.substring(qStart) : expr.substring(qStart, qEnd).trim();
            try {
                quality = Float.parseFloat(qString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return quality;
    }

    public static List<Locale> parseAcceptLanguage(String header) {
        if (header == null) {
            return new ArrayList<Locale>();
        }
        ArrayList locales = new ArrayList();
        for (String item : StringUtils.tokenize((String)header, (char[])new char[]{','})) {
            String[] pair = StringUtils.tokenize((String)item, (char[])new char[]{';'});
            locales.add(new Item<Locale>(HttpUtils.parseLocale(pair[0]), pair.length > 1 ? Float.parseFloat(pair[1]) : 1.0f));
        }
        return Item.sortAndGet(locales);
    }

    public static List<Locale> parseContentLanguage(String header) {
        if (header == null) {
            return new ArrayList<Locale>();
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String item : StringUtils.tokenize((String)header, (char[])new char[]{','})) {
            locales.add(HttpUtils.parseLocale(item));
        }
        return locales;
    }

    public static Locale parseLocale(String locale) {
        String[] parts = StringUtils.tokenize((String)locale, (char[])new char[]{'-', '_'});
        switch (parts.length) {
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
        }
        return new Locale(parts[0]);
    }

    public static HttpPostRequestDecoder createPostRequestDecoder(HttpRequest request, InputStream inputStream, String charset) {
        ByteBuf data;
        boolean canMark = inputStream.markSupported();
        try {
            if (canMark) {
                inputStream.mark(Integer.MAX_VALUE);
            }
            if (inputStream.available() == 0) {
                HttpPostRequestDecoder httpPostRequestDecoder = null;
                return httpPostRequestDecoder;
            }
            data = HEAP_ALLOC.buffer();
            ByteBufOutputStream os = new ByteBufOutputStream(data);
            StreamUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        catch (IOException e2) {
            throw new DecodeException("Error while reading post data: " + e2.getMessage(), (Throwable)e2);
        }
        finally {
            try {
                if (canMark) {
                    inputStream.reset();
                } else {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        DefaultFullHttpRequest nRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, request.uri(), data, (HttpHeaders)new DefaultHttpHeaders(false), (HttpHeaders)new DefaultHttpHeaders(false));
        HttpHeaders headers = nRequest.headers();
        request.headers().forEach(e -> headers.add((CharSequence)e.getKey(), e.getValue()));
        if (charset == null) {
            return new HttpPostRequestDecoder(DATA_FACTORY, (io.netty.handler.codec.http.HttpRequest)nRequest);
        }
        return new HttpPostRequestDecoder(DATA_FACTORY, (io.netty.handler.codec.http.HttpRequest)nRequest, Charset.forName(charset));
    }

    public static String readPostValue(InterfaceHttpData item) {
        try {
            return ((Attribute)item).getValue();
        }
        catch (IOException e) {
            throw new DecodeException("Error while reading post value: " + e.getMessage(), (Throwable)e);
        }
    }

    public static HttpRequest.FileUpload readUpload(InterfaceHttpData item) {
        return new DefaultFileUploadAdapter((FileUpload)item);
    }

    private static final class Item<V>
    implements Comparable<Item<V>> {
        private final V value;
        private final float q;

        public Item(V value, float q) {
            this.value = value;
            this.q = q;
        }

        @Override
        public int compareTo(Item<V> o) {
            return Float.compare(o.q, this.q);
        }

        public static <T> List<T> sortAndGet(List<Item<T>> items) {
            int size = items.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            if (size == 1) {
                return Collections.singletonList(items.get((int)0).value);
            }
            Collections.sort(items);
            ArrayList values = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                values.add(items.get((int)i).value);
            }
            return values;
        }
    }

    private static final class DefaultFileUploadAdapter
    implements HttpRequest.FileUpload {
        private final FileUpload fu;
        private InputStream inputStream;

        DefaultFileUploadAdapter(FileUpload fu) {
            this.fu = fu;
        }

        @Override
        public String name() {
            return this.fu.getName();
        }

        @Override
        public String filename() {
            return this.fu.getFilename();
        }

        @Override
        public String contentType() {
            return this.fu.getContentType();
        }

        @Override
        public int size() {
            return (int)this.fu.length();
        }

        @Override
        public InputStream inputStream() {
            if (this.inputStream == null) {
                this.inputStream = new ByteBufInputStream(this.fu.content());
            }
            return this.inputStream;
        }
    }
}

