/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4;

import java.util.Iterator;
import java.util.Map;

public final class StringValueIterator
implements Iterator<Map.Entry<CharSequence, String>> {
    private final Iterator<Map.Entry<CharSequence, CharSequence>> iterator;

    public StringValueIterator(Iterator<Map.Entry<CharSequence, CharSequence>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<CharSequence, String> next() {
        return new ValueEntry(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private static final class ValueEntry
    implements Map.Entry<CharSequence, String> {
        private final Map.Entry<CharSequence, CharSequence> entry;
        private String value;

        ValueEntry(Map.Entry<CharSequence, CharSequence> entry) {
            this.entry = entry;
        }

        @Override
        public CharSequence getKey() {
            return this.entry.getKey();
        }

        @Override
        public String getValue() {
            CharSequence cs;
            if (this.value == null && (cs = this.entry.getValue()) != null) {
                this.value = cs.toString();
            }
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String old = this.getValue();
            this.entry.setValue(value);
            return old;
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

