/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.etcd.option;

import io.etcd.jetcd.ByteSequence;
import io.grpc.Status;
import io.netty.handler.codec.http2.Http2Exception;

public class OptionUtil {
    public static final byte[] NO_PREFIX_END = new byte[]{0};

    public static final ByteSequence prefixEndOf(ByteSequence prefix) {
        byte[] endKey = (byte[])prefix.getBytes().clone();
        if (prefix.size() > 0) {
            endKey[endKey.length - 1] = (byte)(endKey[endKey.length - 1] + 1);
            return ByteSequence.from((byte[])endKey);
        }
        return ByteSequence.from((byte[])NO_PREFIX_END);
    }

    public static boolean isRecoverable(Status status) {
        return OptionUtil.isHaltError(status) || OptionUtil.isNoLeaderError(status) || status.getCode() == Status.Code.NOT_FOUND;
    }

    public static boolean isHaltError(Status status) {
        return status.getCode() != Status.Code.UNAVAILABLE && status.getCode() != Status.Code.INTERNAL;
    }

    public static boolean isNoLeaderError(Status status) {
        return status.getCode() == Status.Code.UNAVAILABLE && "etcdserver: no leader".equals(status.getDescription());
    }

    public static boolean isProtocolError(Throwable e) {
        if (e == null) {
            return false;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            Http2Exception t;
            if (!(cause instanceof Http2Exception) || !"PROTOCOL_ERROR".equals((t = (Http2Exception)cause).error().name())) continue;
            return true;
        }
        return false;
    }
}

