/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Endpoint;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.ChannelHandlerDelegate;

public abstract class AbstractPeer
implements Endpoint,
ChannelHandler {
    private final ChannelHandler handler;
    private volatile URL url;
    private volatile boolean closing;
    private volatile boolean closed;

    public AbstractPeer(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    protected AbstractPeer() {
        this.handler = null;
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.send(message, this.url.getParameter("sent", false));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void close(int timeout) {
        this.close();
    }

    @Override
    public void startClose() {
        if (this.isClosed()) {
            return;
        }
        this.closing = true;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    protected void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url;
    }

    @Override
    public ChannelHandler getChannelHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)this.handler).getHandler();
        }
        return this.handler;
    }

    @Deprecated
    public ChannelHandler getHandler() {
        return this.getDelegateHandler();
    }

    public ChannelHandler getDelegateHandler() {
        return this.handler;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isClosing() {
        return this.closing && !this.closed;
    }

    @Override
    public void connected(Channel ch) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.connected(ch);
    }

    @Override
    public void disconnected(Channel ch) throws RemotingException {
        this.handler.disconnected(ch);
    }

    @Override
    public void sent(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.sent(ch, msg);
    }

    @Override
    public void received(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.received(ch, msg);
    }

    @Override
    public void caught(Channel ch, Throwable ex) throws RemotingException {
        this.handler.caught(ch, ex);
    }
}

