/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;

public class SslContexts {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SslContexts.class);

    public static SslContext buildServerSslContext(URL url) {
        SslContextBuilder sslClientContextBuilder;
        ConfigManager globalConfigManager = url.getOrDefaultApplicationModel().getApplicationConfigManager();
        SslConfig sslConfig = (SslConfig)globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        InputStream serverKeyCertChainPathStream = null;
        InputStream serverPrivateKeyPathStream = null;
        InputStream serverTrustCertStream = null;
        try {
            serverKeyCertChainPathStream = sslConfig.getServerKeyCertChainPathStream();
            serverPrivateKeyPathStream = sslConfig.getServerPrivateKeyPathStream();
            serverTrustCertStream = sslConfig.getServerTrustCertCollectionPathStream();
            String password = sslConfig.getServerKeyPassword();
            sslClientContextBuilder = password != null ? SslContextBuilder.forServer((InputStream)serverKeyCertChainPathStream, (InputStream)serverPrivateKeyPathStream, (String)password) : SslContextBuilder.forServer((InputStream)serverKeyCertChainPathStream, (InputStream)serverPrivateKeyPathStream);
            if (serverTrustCertStream != null) {
                sslClientContextBuilder.trustManager(serverTrustCertStream);
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", e);
            }
            catch (Throwable throwable) {
                SslContexts.safeCloseStream(serverTrustCertStream);
                SslContexts.safeCloseStream(serverKeyCertChainPathStream);
                SslContexts.safeCloseStream(serverPrivateKeyPathStream);
                throw throwable;
            }
        }
        SslContexts.safeCloseStream(serverTrustCertStream);
        SslContexts.safeCloseStream(serverKeyCertChainPathStream);
        SslContexts.safeCloseStream(serverPrivateKeyPathStream);
        try {
            return sslClientContextBuilder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    public static SslContext buildClientSslContext(URL url) {
        InputStream clientPrivateKeyFilePath;
        InputStream clientCertChainFilePath;
        InputStream clientTrustCertCollectionPath;
        SslContextBuilder builder;
        block8: {
            ConfigManager globalConfigManager = url.getOrDefaultApplicationModel().getApplicationConfigManager();
            SslConfig sslConfig = (SslConfig)globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
            builder = SslContextBuilder.forClient();
            clientTrustCertCollectionPath = null;
            clientCertChainFilePath = null;
            clientPrivateKeyFilePath = null;
            try {
                clientTrustCertCollectionPath = sslConfig.getClientTrustCertCollectionPathStream();
                if (clientTrustCertCollectionPath != null) {
                    builder.trustManager(clientTrustCertCollectionPath);
                }
                clientCertChainFilePath = sslConfig.getClientKeyCertChainPathStream();
                clientPrivateKeyFilePath = sslConfig.getClientPrivateKeyPathStream();
                if (clientCertChainFilePath == null || clientPrivateKeyFilePath == null) break block8;
                String password = sslConfig.getClientKeyPassword();
                if (password != null) {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath, password);
                    break block8;
                }
                builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath);
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException("Could not find certificate file or find invalid certificate.", e);
                }
                catch (Throwable throwable) {
                    SslContexts.safeCloseStream(clientTrustCertCollectionPath);
                    SslContexts.safeCloseStream(clientCertChainFilePath);
                    SslContexts.safeCloseStream(clientPrivateKeyFilePath);
                    throw throwable;
                }
            }
        }
        SslContexts.safeCloseStream(clientTrustCertCollectionPath);
        SslContexts.safeCloseStream(clientCertChainFilePath);
        SslContexts.safeCloseStream(clientPrivateKeyFilePath);
        try {
            return builder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    private static SslProvider findSslProvider() {
        if (OpenSsl.isAvailable()) {
            logger.debug("Using OPENSSL provider.");
            return SslProvider.OPENSSL;
        }
        if (SslContexts.checkJdkProvider()) {
            logger.debug("Using JDK provider.");
            return SslProvider.JDK;
        }
        throw new IllegalStateException("Could not find any valid TLS provider, please check your dependency or deployment environment, usually netty-tcnative, Conscrypt, or Jetty NPN/ALPN is needed.");
    }

    private static boolean checkJdkProvider() {
        Provider[] jdkProviders = Security.getProviders("SSLContext.TLS");
        return jdkProviders != null && jdkProviders.length > 0;
    }

    private static void safeCloseStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.warn("6-13", "", "", "Failed to close a stream.", (Throwable)e);
        }
    }
}

