/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support;

import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.support.Replier;
import org.apache.dubbo.remoting.exchange.support.ReplierDispatcher;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.TelnetHandlerAdapter;
import org.apache.dubbo.remoting.transport.ChannelHandlerDispatcher;

public class ExchangeHandlerDispatcher
implements ExchangeHandler {
    private final ReplierDispatcher replierDispatcher;
    private final ChannelHandlerDispatcher handlerDispatcher;
    private final TelnetHandler telnetHandler;

    public ExchangeHandlerDispatcher() {
        this((Replier<?>)null, (ChannelHandler[])null);
    }

    public ExchangeHandlerDispatcher(Replier<?> replier) {
        this(replier, null);
    }

    public ExchangeHandlerDispatcher(ChannelHandler ... handlers) {
        this((Replier<?>)null, handlers);
    }

    public ExchangeHandlerDispatcher(Replier<?> replier, ChannelHandler ... handlers) {
        this.replierDispatcher = new ReplierDispatcher(replier);
        this.handlerDispatcher = new ChannelHandlerDispatcher(handlers);
        this.telnetHandler = new TelnetHandlerAdapter();
    }

    public ExchangeHandlerDispatcher addChannelHandler(ChannelHandler handler) {
        this.handlerDispatcher.addChannelHandler(handler);
        return this;
    }

    public ExchangeHandlerDispatcher removeChannelHandler(ChannelHandler handler) {
        this.handlerDispatcher.removeChannelHandler(handler);
        return this;
    }

    public <T> ExchangeHandlerDispatcher addReplier(Class<T> type, Replier<T> replier) {
        this.replierDispatcher.addReplier(type, replier);
        return this;
    }

    public <T> ExchangeHandlerDispatcher removeReplier(Class<T> type) {
        this.replierDispatcher.removeReplier(type);
        return this;
    }

    @Override
    public CompletableFuture<Object> reply(ExchangeChannel channel, Object request) throws RemotingException {
        return CompletableFuture.completedFuture(this.replierDispatcher.reply(channel, request));
    }

    @Override
    public void connected(Channel channel) {
        this.handlerDispatcher.connected(channel);
    }

    @Override
    public void disconnected(Channel channel) {
        this.handlerDispatcher.disconnected(channel);
    }

    @Override
    public void sent(Channel channel, Object message) {
        this.handlerDispatcher.sent(channel, message);
    }

    @Override
    public void received(Channel channel, Object message) {
        this.handlerDispatcher.received(channel, message);
    }

    @Override
    public void caught(Channel channel, Throwable exception) {
        this.handlerDispatcher.caught(channel, exception);
    }

    @Override
    public String telnet(Channel channel, String message) throws RemotingException {
        return this.telnetHandler.telnet(channel, message);
    }
}

