/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.transport.AbstractChannelHandlerDelegate;

public class DecodeHandler
extends AbstractChannelHandlerDelegate {
    private static final Logger log = LoggerFactory.getLogger(DecodeHandler.class);

    public DecodeHandler(ChannelHandler handler) {
        super(handler);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        if (message instanceof Decodeable) {
            this.decode(message);
        }
        if (message instanceof Request) {
            this.decode(((Request)message).getData());
        }
        if (message instanceof Response) {
            this.decode(((Response)message).getResult());
        }
        this.handler.received(channel, message);
    }

    private void decode(Object message) {
        block4: {
            if (message instanceof Decodeable) {
                try {
                    ((Decodeable)message).decode();
                    if (log.isDebugEnabled()) {
                        log.debug("Decode decodeable message " + message.getClass().getName());
                    }
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Call Decodeable.decode failed: " + e.getMessage(), e);
                }
            }
        }
    }
}

