/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multiple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.DefaultPage;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

public class MultipleServiceDiscovery
implements ServiceDiscovery {
    public static final String REGISTRY_PREFIX_KEY = "child.";
    private final Map<String, ServiceDiscovery> serviceDiscoveries = new ConcurrentHashMap<String, ServiceDiscovery>();
    private URL registryURL;
    private ServiceInstance serviceInstance;
    private String applicationName;
    private volatile boolean isDestroy;

    public void initialize(URL registryURL) throws Exception {
        this.registryURL = registryURL;
        this.applicationName = registryURL.getParameter("application");
        Map parameters = registryURL.getParameters();
        for (String key : parameters.keySet()) {
            if (!key.startsWith(REGISTRY_PREFIX_KEY)) continue;
            URL url = URL.valueOf((String)registryURL.getParameter(key)).addParameter("application", this.applicationName).addParameter("registry-type", "service");
            ServiceDiscovery serviceDiscovery = ServiceDiscoveryFactory.getExtension((URL)url).getServiceDiscovery(url);
            serviceDiscovery.initialize(url);
            this.serviceDiscoveries.put(key, serviceDiscovery);
        }
    }

    public URL getUrl() {
        return this.registryURL;
    }

    public void destroy() throws Exception {
        this.isDestroy = true;
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            serviceDiscovery.destroy();
        }
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    public void register(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceInstance = serviceInstance;
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.register(serviceInstance));
    }

    public void update(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.update(serviceInstance));
    }

    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.unregister(serviceInstance));
    }

    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        MultiServiceInstancesChangedListener multiListener = (MultiServiceInstancesChangedListener)listener;
        for (String registryKey : this.serviceDiscoveries.keySet()) {
            ServiceDiscovery serviceDiscovery = this.serviceDiscoveries.get(registryKey);
            SingleServiceInstancesChangedListener singleListener = multiListener.getAndComputeIfAbsent(registryKey, k -> new SingleServiceInstancesChangedListener(listener.getServiceNames(), serviceDiscovery, multiListener));
            serviceDiscovery.addServiceInstancesChangedListener((ServiceInstancesChangedListener)singleListener);
        }
    }

    public ServiceInstancesChangedListener createListener(Set<String> serviceNames) {
        return new MultiServiceInstancesChangedListener(serviceNames, this);
    }

    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        ArrayList serviceInstanceList = new ArrayList();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            Page serviceInstancePage = serviceDiscovery.getInstances(serviceName, offset, pageSize, healthyOnly);
            serviceInstanceList.addAll(serviceInstancePage.getData());
        }
        return new DefaultPage(offset, pageSize, serviceInstanceList, serviceInstanceList.size());
    }

    public Set<String> getServices() {
        HashSet<String> services = new HashSet<String>();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            services.addAll(serviceDiscovery.getServices());
        }
        return services;
    }

    public ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    protected static class SingleServiceInstancesChangedListener
    extends ServiceInstancesChangedListener {
        private final MultiServiceInstancesChangedListener multiListener;
        volatile ServiceInstancesChangedEvent event;

        public SingleServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery, MultiServiceInstancesChangedListener multiListener) {
            super(serviceNames, serviceDiscovery);
            this.multiListener = multiListener;
        }

        public void onEvent(ServiceInstancesChangedEvent event) {
            this.event = event;
            if (this.multiListener != null) {
                this.multiListener.onEvent(event);
            }
        }
    }

    protected static class MultiServiceInstancesChangedListener
    extends ServiceInstancesChangedListener {
        private final Map<String, SingleServiceInstancesChangedListener> singleListenerMap = new ConcurrentHashMap<String, SingleServiceInstancesChangedListener>();

        public MultiServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
            super(serviceNames, serviceDiscovery);
        }

        public void onEvent(ServiceInstancesChangedEvent event) {
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
            for (SingleServiceInstancesChangedListener singleListener : this.singleListenerMap.values()) {
                if (null == singleListener.event || null == singleListener.event.getServiceInstances()) continue;
                for (ServiceInstance serviceInstance : singleListener.event.getServiceInstances()) {
                    if (serviceInstances.contains(serviceInstance)) continue;
                    serviceInstances.add(serviceInstance);
                }
            }
            super.onEvent(new ServiceInstancesChangedEvent(event.getServiceName(), serviceInstances));
        }

        public void putSingleListener(String registryKey, SingleServiceInstancesChangedListener singleListener) {
            this.singleListenerMap.put(registryKey, singleListener);
        }

        public SingleServiceInstancesChangedListener getAndComputeIfAbsent(String registryKey, Function<String, SingleServiceInstancesChangedListener> func) {
            return this.singleListenerMap.computeIfAbsent(registryKey, func);
        }
    }
}

