/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.registry.integration.ReferenceCountExporter;
import org.apache.dubbo.rpc.Exporter;

public class ExporterFactory {
    private final ConcurrentHashMap<String, ReferenceCountExporter<?>> exporters = new ConcurrentHashMap();

    protected ReferenceCountExporter<?> createExporter(String providerKey, Callable<Exporter<?>> exporterProducer) {
        return (ReferenceCountExporter)ConcurrentHashMapUtils.computeIfAbsent(this.exporters, (Object)providerKey, key -> {
            try {
                return new ReferenceCountExporter((Exporter)exporterProducer.call(), (String)key, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void remove(String key, ReferenceCountExporter<?> exporter) {
        this.exporters.remove(key, exporter);
    }
}

