/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultServiceInstance
implements ServiceInstance {
    private static final long serialVersionUID = 1149677083747278100L;
    private String rawAddress;
    private String serviceName;
    private String host;
    private int port;
    private boolean enabled = true;
    private boolean healthy = true;
    private Map<String, String> metadata = new HashMap<String, String>();
    private transient String address;
    private transient MetadataInfo serviceMetadata;
    private transient String registryCluster;
    private transient Map<String, String> extendParams;
    private transient List<Endpoint> endpoints;
    private transient ApplicationModel applicationModel;
    private transient Map<String, InstanceAddressURL> instanceAddressURL = new ConcurrentHashMap<String, InstanceAddressURL>();

    public DefaultServiceInstance() {
    }

    public DefaultServiceInstance(DefaultServiceInstance other) {
        this.serviceName = other.serviceName;
        this.host = other.host;
        this.port = other.port;
        this.enabled = other.enabled;
        this.healthy = other.healthy;
        this.serviceMetadata = other.serviceMetadata;
        this.registryCluster = other.registryCluster;
        this.address = null;
        this.metadata = new HashMap<String, String>(other.metadata);
        this.applicationModel = other.applicationModel;
        this.extendParams = other.extendParams != null ? new HashMap<String, String>(other.extendParams) : other.extendParams;
        this.endpoints = other.endpoints != null ? new ArrayList<Endpoint>(other.endpoints) : other.endpoints;
    }

    public DefaultServiceInstance(String serviceName, String host, Integer port, ApplicationModel applicationModel) {
        if (port == null || port < 1) {
            throw new IllegalArgumentException("The port value is illegal, the value is " + port);
        }
        this.serviceName = serviceName;
        this.host = host;
        this.port = port;
        this.setApplicationModel(applicationModel);
    }

    public DefaultServiceInstance(String serviceName, ApplicationModel applicationModel) {
        this.serviceName = serviceName;
        this.setApplicationModel(applicationModel);
    }

    public void setRawAddress(String rawAddress) {
        this.rawAddress = rawAddress;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            this.address = DefaultServiceInstance.getAddress(this.host, this.port);
        }
        return this.address;
    }

    private static String getAddress(String host, Integer port) {
        return port != null && port <= 0 ? host : host + ':' + port;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public SortedMap<String, String> getSortedMetadata() {
        return new TreeMap<String, String>(this.getMetadata());
    }

    @Override
    public String getRegistryCluster() {
        return this.registryCluster;
    }

    @Override
    public void setRegistryCluster(String registryCluster) {
        this.registryCluster = registryCluster;
    }

    @Override
    public Map<String, String> getExtendParams() {
        if (this.extendParams == null) {
            return Collections.emptyMap();
        }
        return this.extendParams;
    }

    @Override
    public String getExtendParam(String key) {
        if (this.extendParams == null) {
            return null;
        }
        return this.extendParams.get(key);
    }

    @Override
    public String putExtendParam(String key, String value) {
        if (this.extendParams == null) {
            this.extendParams = new HashMap<String, String>();
        }
        return this.extendParams.put(key, value);
    }

    @Override
    public String putExtendParamIfAbsent(String key, String value) {
        if (this.extendParams == null) {
            this.extendParams = new HashMap<String, String>();
        }
        return this.extendParams.putIfAbsent(key, value);
    }

    @Override
    public String removeExtendParam(String key) {
        if (this.extendParams == null) {
            return null;
        }
        return this.extendParams.remove(key);
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public List<Endpoint> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new LinkedList<Endpoint>(JsonUtils.getJson().toJavaList(this.metadata.get("dubbo.endpoints"), Endpoint.class));
        }
        return this.endpoints;
    }

    public DefaultServiceInstance copyFrom(Endpoint endpoint) {
        DefaultServiceInstance copyOfInstance = new DefaultServiceInstance(this);
        copyOfInstance.setPort(endpoint.getPort());
        return copyOfInstance;
    }

    public DefaultServiceInstance copyFrom(int port) {
        DefaultServiceInstance copyOfInstance = new DefaultServiceInstance(this);
        copyOfInstance.setPort(port);
        return copyOfInstance;
    }

    @Override
    public Map<String, String> getAllParams() {
        if (this.extendParams == null) {
            return this.metadata;
        }
        HashMap<String, String> allParams = new HashMap<String, String>((int)((float)(this.metadata.size() + this.extendParams.size()) / 0.75f + 1.0f));
        allParams.putAll(this.metadata);
        allParams.putAll(this.extendParams);
        return allParams;
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    @Transient
    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public MetadataInfo getServiceMetadata() {
        return this.serviceMetadata;
    }

    @Override
    public void setServiceMetadata(MetadataInfo serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
        this.instanceAddressURL.clear();
    }

    @Override
    public InstanceAddressURL toURL(String protocol) {
        return this.instanceAddressURL.computeIfAbsent(protocol, key -> new InstanceAddressURL(this, this.serviceMetadata, protocol));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServiceInstance)) {
            return false;
        }
        DefaultServiceInstance that = (DefaultServiceInstance)o;
        boolean equals = Objects.equals(this.getServiceName(), that.getServiceName()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort());
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            if (entry.getKey().equals("dubbo.metadata.revision")) continue;
            if (entry.getValue() == null) {
                equals = equals && entry.getValue() == that.getMetadata().get(entry.getKey());
                continue;
            }
            equals = equals && entry.getValue().equals(that.getMetadata().get(entry.getKey()));
        }
        return equals;
    }

    public int hashCode() {
        int result = Objects.hash(this.getServiceName(), this.getHost(), this.getPort());
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            if (entry.getKey().equals("dubbo.metadata.revision")) continue;
            result = 31 * result + (entry.getValue() == null ? 0 : entry.getValue().hashCode());
        }
        return result;
    }

    public String toString() {
        return this.rawAddress == null ? this.toFullString() : this.rawAddress;
    }

    public String toFullString() {
        return "DefaultServiceInstance{serviceName='" + this.serviceName + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", enabled=" + this.enabled + ", healthy=" + this.healthy + ", metadata=" + this.metadata + '}';
    }

    public static class Endpoint {
        int port;
        String protocol;

        public Endpoint() {
        }

        public Endpoint(int port, String protocol) {
            this.port = port;
            this.protocol = protocol;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }
    }
}

