/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleHandler;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationRule;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MigrationRuleListener
implements RegistryProtocolListener,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleListener.class);
    private Set<MigrationRuleHandler> listeners = new ConcurrentHashSet();
    private DynamicConfiguration configuration;
    private volatile String rawRule;

    public MigrationRuleListener() {
        Optional optional = ApplicationModel.getEnvironment().getDynamicConfiguration();
        if (optional.isPresent()) {
            this.configuration = (DynamicConfiguration)optional.get();
            logger.info("Listening for migration rules on dataId-" + MigrationRule.RULE_KEY + " group-" + "MIGRATION");
            this.configuration.addListener(MigrationRule.RULE_KEY, "MIGRATION", (ConfigurationListener)this);
            this.rawRule = this.configuration.getConfig(MigrationRule.RULE_KEY, "MIGRATION");
            if (StringUtils.isEmpty((String)this.rawRule)) {
                this.rawRule = "INIT";
            }
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("config center is not configured!");
            }
            this.rawRule = "INIT";
        }
        this.process(new ConfigChangedEvent(MigrationRule.RULE_KEY, "MIGRATION", this.rawRule));
    }

    public synchronized void process(ConfigChangedEvent event) {
        this.rawRule = event.getContent();
        if (StringUtils.isEmpty((String)this.rawRule)) {
            logger.warn("Received empty migration rule, will ignore.");
            return;
        }
        logger.info("Using the following migration rule to migrate:");
        logger.info(this.rawRule);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            this.listeners.forEach(listener -> listener.doMigrate(this.rawRule));
        }
    }

    @Override
    public synchronized void onExport(RegistryProtocol registryProtocol, Exporter<?> exporter) {
    }

    @Override
    public synchronized void onRefer(RegistryProtocol registryProtocol, ClusterInvoker<?> invoker, URL url) {
        MigrationInvoker migrationInvoker = (MigrationInvoker)invoker;
        MigrationRuleHandler migrationListener = new MigrationRuleHandler(migrationInvoker);
        this.listeners.add(migrationListener);
        migrationListener.doMigrate(this.rawRule);
    }

    @Override
    public void onDestroy() {
        if (null != this.configuration) {
            this.configuration.removeListener(MigrationRule.RULE_KEY, "MIGRATION", (ConfigurationListener)this);
        }
    }
}

