/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.InvokersChangedListener;
import org.apache.dubbo.registry.client.migration.MigrationAddressComparator;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationRule;

public class MigrationInvoker<T>
implements MigrationClusterInvoker<T> {
    private Logger logger = LoggerFactory.getLogger(MigrationInvoker.class);
    private URL url;
    private URL consumerUrl;
    private Cluster cluster;
    private Registry registry;
    private Class<T> type;
    private RegistryProtocol registryProtocol;
    private volatile ClusterInvoker<T> invoker;
    private volatile ClusterInvoker<T> serviceDiscoveryInvoker;
    private volatile ClusterInvoker<T> currentAvailableInvoker;
    private MigrationRule rule;
    private boolean migrationMultiRegistry;
    private volatile AtomicBoolean invokersChanged = new AtomicBoolean(true);

    public MigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        this(null, null, registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    public MigrationInvoker(ClusterInvoker<T> invoker, ClusterInvoker<T> serviceDiscoveryInvoker, RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        this.invoker = invoker;
        this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
        this.registryProtocol = registryProtocol;
        this.cluster = cluster;
        this.registry = registry;
        this.type = type;
        this.url = url;
        this.consumerUrl = consumerUrl;
        this.migrationMultiRegistry = url.getParameter("MIGRATION_MULTI_REGISTRY", false);
    }

    public ClusterInvoker<T> getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClusterInvoker<T> invoker) {
        this.invoker = invoker;
    }

    public ClusterInvoker<T> getServiceDiscoveryInvoker() {
        return this.serviceDiscoveryInvoker;
    }

    public void setServiceDiscoveryInvoker(ClusterInvoker<T> serviceDiscoveryInvoker) {
        this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
    }

    public Class<T> getInterface() {
        return this.type;
    }

    public synchronized void migrateToServiceDiscoveryInvoker(boolean forceMigrate) {
        if (!forceMigrate) {
            this.refreshServiceDiscoveryInvoker();
            this.refreshInterfaceInvoker();
            this.setListener(this.invoker, () -> this.compareAddresses(this.serviceDiscoveryInvoker, this.invoker));
            this.setListener(this.serviceDiscoveryInvoker, () -> this.compareAddresses(this.serviceDiscoveryInvoker, this.invoker));
        } else {
            this.refreshServiceDiscoveryInvoker();
            this.setListener(this.serviceDiscoveryInvoker, () -> this.destroyInterfaceInvoker(this.invoker));
        }
    }

    public void reRefer(URL newSubscribeUrl) {
        this.url = this.url.addParameter("refer", StringUtils.toQueryString((Map)newSubscribeUrl.getParameters()));
        if (this.invoker != null && !this.invoker.isDestroyed()) {
            this.doReSubscribe(this.invoker, newSubscribeUrl);
        }
        if (this.serviceDiscoveryInvoker != null && !this.serviceDiscoveryInvoker.isDestroyed()) {
            this.doReSubscribe(this.serviceDiscoveryInvoker, newSubscribeUrl);
        }
    }

    private void doReSubscribe(ClusterInvoker<T> invoker, URL newSubscribeUrl) {
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        URL oldSubscribeUrl = directory.getRegisteredConsumerUrl();
        Registry registry = directory.getRegistry();
        registry.unregister(directory.getRegisteredConsumerUrl());
        directory.unSubscribe(RegistryProtocol.toSubscribeUrl(oldSubscribeUrl));
        if (directory.isShouldRegister()) {
            registry.register(directory.getRegisteredConsumerUrl());
            directory.setRegisteredConsumerUrl(newSubscribeUrl);
        }
        directory.buildRouterChain(newSubscribeUrl);
        directory.subscribe(RegistryProtocol.toSubscribeUrl(newSubscribeUrl));
    }

    public synchronized void fallbackToInterfaceInvoker() {
        this.refreshInterfaceInvoker();
        this.setListener(this.invoker, () -> this.destroyServiceDiscoveryInvoker(this.serviceDiscoveryInvoker));
    }

    public Result invoke(Invocation invocation) throws RpcException {
        if (!this.checkInvokerAvailable(this.serviceDiscoveryInvoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using interface addresses to handle invocation, interface " + this.type.getName() + ", total address size " + (this.invoker.getDirectory().getAllInvokers() == null ? "is null" : Integer.valueOf(this.invoker.getDirectory().getAllInvokers().size())));
            }
            return this.invoker.invoke(invocation);
        }
        if (!this.checkInvokerAvailable(this.invoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using instance addresses to handle invocation, interface " + this.type.getName() + ", total address size " + (this.serviceDiscoveryInvoker.getDirectory().getAllInvokers() == null ? " is null " : Integer.valueOf(this.serviceDiscoveryInvoker.getDirectory().getAllInvokers().size())));
            }
            return this.serviceDiscoveryInvoker.invoke(invocation);
        }
        return this.currentAvailableInvoker.invoke(invocation);
    }

    public boolean isAvailable() {
        return this.invoker != null && this.invoker.isAvailable() || this.serviceDiscoveryInvoker != null && this.serviceDiscoveryInvoker.isAvailable();
    }

    public void destroy() {
        if (this.invoker != null) {
            this.invoker.destroy();
        }
        if (this.serviceDiscoveryInvoker != null) {
            this.serviceDiscoveryInvoker.destroy();
        }
    }

    public URL getUrl() {
        if (this.invoker != null) {
            return this.invoker.getUrl();
        }
        if (this.serviceDiscoveryInvoker != null) {
            return this.serviceDiscoveryInvoker.getUrl();
        }
        return this.consumerUrl;
    }

    public URL getRegistryUrl() {
        if (this.invoker != null) {
            return this.invoker.getRegistryUrl();
        }
        if (this.serviceDiscoveryInvoker != null) {
            this.serviceDiscoveryInvoker.getRegistryUrl();
        }
        return this.url;
    }

    public Directory<T> getDirectory() {
        if (this.invoker != null) {
            return this.invoker.getDirectory();
        }
        if (this.serviceDiscoveryInvoker != null) {
            return this.serviceDiscoveryInvoker.getDirectory();
        }
        return null;
    }

    public boolean isDestroyed() {
        return !(this.invoker != null && !this.invoker.isDestroyed() || this.serviceDiscoveryInvoker != null && !this.serviceDiscoveryInvoker.isDestroyed());
    }

    public AtomicBoolean invokersChanged() {
        return this.invokersChanged;
    }

    private synchronized void compareAddresses(ClusterInvoker<T> serviceDiscoveryInvoker, ClusterInvoker<T> invoker) {
        Set detectors;
        this.invokersChanged.set(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(invoker.getDirectory().getAllInvokers() == null ? "null" : invoker.getDirectory().getAllInvokers().size() + "");
        }
        if ((detectors = ExtensionLoader.getExtensionLoader(MigrationAddressComparator.class).getSupportedExtensionInstances()) != null && detectors.stream().allMatch(migrationDetector -> migrationDetector.shouldMigrate(serviceDiscoveryInvoker, invoker))) {
            this.discardInterfaceInvokerAddress(invoker);
        } else {
            this.discardServiceDiscoveryInvokerAddress(serviceDiscoveryInvoker);
        }
    }

    private synchronized void setAddressChanged() {
        this.invokersChanged.set(true);
    }

    public synchronized void destroyServiceDiscoveryInvoker(ClusterInvoker<?> serviceDiscoveryInvoker) {
        if (this.checkInvokerAvailable(this.invoker)) {
            this.currentAvailableInvoker = this.invoker;
        }
        if (serviceDiscoveryInvoker != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Destroying instance address invokers, will not listen for address changes until re-subscribed, " + this.type.getName());
            }
            serviceDiscoveryInvoker.destroy();
        }
    }

    public synchronized void discardServiceDiscoveryInvokerAddress(ClusterInvoker<?> serviceDiscoveryInvoker) {
        if (this.checkInvokerAvailable(this.invoker)) {
            this.currentAvailableInvoker = this.invoker;
        }
        if (serviceDiscoveryInvoker != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Discarding instance addresses, total size " + (null == serviceDiscoveryInvoker.getDirectory().getAllInvokers() ? "null" : Integer.valueOf(serviceDiscoveryInvoker.getDirectory().getAllInvokers().size())));
            }
            serviceDiscoveryInvoker.getDirectory().discordAddresses();
        }
    }

    public synchronized void refreshServiceDiscoveryInvoker() {
        this.clearListener(this.serviceDiscoveryInvoker);
        if (this.needRefresh(this.serviceDiscoveryInvoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Re-subscribing instance addresses, current interface " + this.type.getName());
            }
            this.serviceDiscoveryInvoker = this.registryProtocol.getServiceDiscoveryInvoker(this.cluster, this.registry, this.type, this.url);
            if (this.migrationMultiRegistry) {
                this.setListener(this.serviceDiscoveryInvoker, () -> this.setAddressChanged());
            }
        }
    }

    private void clearListener(ClusterInvoker<T> invoker) {
        if (this.migrationMultiRegistry) {
            return;
        }
        if (invoker == null) {
            return;
        }
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        directory.setInvokersChangedListener(null);
    }

    private void setListener(ClusterInvoker<T> invoker, InvokersChangedListener listener) {
        if (invoker == null) {
            return;
        }
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        directory.setInvokersChangedListener(listener);
    }

    public synchronized void refreshInterfaceInvoker() {
        this.clearListener(this.invoker);
        if (this.needRefresh(this.invoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Re-subscribing interface addresses for interface " + this.type.getName());
            }
            this.invoker = this.registryProtocol.getInvoker(this.cluster, this.registry, this.type, this.url);
            if (this.migrationMultiRegistry) {
                this.setListener(this.serviceDiscoveryInvoker, () -> this.setAddressChanged());
            }
        }
    }

    public synchronized void destroyInterfaceInvoker(ClusterInvoker<T> invoker) {
        if (this.checkInvokerAvailable(this.serviceDiscoveryInvoker)) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
        }
        if (invoker != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Destroying interface address invokers, will not listen for address changes until re-subscribed, " + this.type.getName());
            }
            invoker.destroy();
        }
    }

    public synchronized void discardInterfaceInvokerAddress(ClusterInvoker<T> invoker) {
        if (this.serviceDiscoveryInvoker != null) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
        }
        if (invoker != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Discarding interface addresses, total address size " + (null == invoker.getDirectory().getAllInvokers() ? "null" : Integer.valueOf(invoker.getDirectory().getAllInvokers().size())));
            }
            invoker.getDirectory().discordAddresses();
        }
    }

    private boolean needRefresh(ClusterInvoker<T> invoker) {
        return invoker == null || invoker.isDestroyed();
    }

    public boolean checkInvokerAvailable(ClusterInvoker<T> invoker) {
        return invoker != null && !invoker.isDestroyed() && invoker.isAvailable();
    }

    public boolean isServiceInvoker() {
        return false;
    }

    public MigrationRule getMigrationRule() {
        return this.rule;
    }

    public void setMigrationRule(MigrationRule rule) {
        this.rule = rule;
    }

    public boolean isMigrationMultiRegistry() {
        return this.migrationMultiRegistry;
    }
}

