/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.store;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class InMemoryWritableMetadataService
implements WritableMetadataService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lock lock = new ReentrantLock();
    ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    ConcurrentMap<String, MetadataInfo> metadataInfos;
    final Semaphore metadataSemaphore = new Semaphore(1);
    ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    ConcurrentNavigableMap<String, String> serviceDefinitions = new ConcurrentSkipListMap<String, String>();

    public InMemoryWritableMetadataService() {
        this.metadataInfos = new ConcurrentHashMap<String, MetadataInfo>();
    }

    public SortedSet<String> getSubscribedURLs() {
        return this.getAllUnmodifiableServiceURLs(this.subscribedServiceURLs);
    }

    private SortedSet<String> getAllUnmodifiableServiceURLs(Map<String, SortedSet<URL>> serviceURLs) {
        TreeSet<URL> bizURLs = new TreeSet<URL>(URLComparator.INSTANCE);
        for (Map.Entry<String, SortedSet<URL>> entry : serviceURLs.entrySet()) {
            SortedSet<URL> urls = entry.getValue();
            if (urls == null) continue;
            for (URL url : urls) {
                if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
                bizURLs.add(url);
            }
        }
        return MetadataService.toSortedStrings(bizURLs);
    }

    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        if ("*".equals(serviceInterface)) {
            return this.getAllUnmodifiableServiceURLs(this.exportedServiceURLs);
        }
        String serviceKey = URL.buildKey((String)serviceInterface, (String)group, (String)version);
        return Collections.unmodifiableSortedSet(this.getServiceURLs(this.exportedServiceURLs, serviceKey, protocol));
    }

    public boolean exportURL(URL url) {
        String[] clusters;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        for (String cluster : clusters = registryCluster.split(",")) {
            MetadataInfo metadataInfo = this.metadataInfos.computeIfAbsent(cluster, k -> new MetadataInfo(ApplicationModel.getName()));
            metadataInfo.addService(new MetadataInfo.ServiceInfo(url));
        }
        this.metadataSemaphore.release();
        return this.addURL(this.exportedServiceURLs, url);
    }

    public boolean unexportURL(URL url) {
        String[] clusters;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        for (String cluster : clusters = registryCluster.split(",")) {
            MetadataInfo metadataInfo = (MetadataInfo)this.metadataInfos.get(cluster);
            metadataInfo.removeService(url.getProtocolServiceKey());
            if (!metadataInfo.getServices().isEmpty()) continue;
            this.metadataInfos.remove(cluster);
        }
        this.metadataSemaphore.release();
        return this.removeURL(this.exportedServiceURLs, url);
    }

    public boolean subscribeURL(URL url) {
        return this.addURL(this.subscribedServiceURLs, url);
    }

    public boolean unsubscribeURL(URL url) {
        return this.removeURL(this.subscribedServiceURLs, url);
    }

    public void publishServiceDefinition(URL providerUrl) {
        try {
            if (!ProtocolUtils.isGeneric((String)providerUrl.getParameter("generic"))) {
                String interfaceName = providerUrl.getParameter("interface");
                if (StringUtils.isNotEmpty((String)interfaceName)) {
                    Class<?> interfaceClass = Class.forName(interfaceName);
                    ServiceDefinition serviceDefinition = ServiceDefinitionBuilder.build(interfaceClass);
                    String data = JSON.toJSONString((Object)serviceDefinition);
                    this.serviceDefinitions.put(providerUrl.getServiceKey(), data);
                    return;
                }
                this.logger.error("publishProvider interfaceName is empty . providerUrl: " + providerUrl.toFullString());
            } else if ("consumer".equalsIgnoreCase(providerUrl.getParameter("side"))) {
                return;
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error("publishProvider getServiceDescriptor error. providerUrl: " + providerUrl.toFullString(), (Throwable)e);
        }
    }

    public String getServiceDefinition(String interfaceName, String version, String group) {
        return (String)this.serviceDefinitions.get(URL.buildKey((String)interfaceName, (String)group, (String)version));
    }

    public String getServiceDefinition(String serviceKey) {
        return (String)this.serviceDefinitions.get(serviceKey);
    }

    public MetadataInfo getMetadataInfo(String revision) {
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        for (Map.Entry entry : this.metadataInfos.entrySet()) {
            MetadataInfo metadataInfo = (MetadataInfo)entry.getValue();
            if (!revision.equals(metadataInfo.calAndGetRevision())) continue;
            return metadataInfo;
        }
        return null;
    }

    public void blockUntilUpdated() {
        try {
            this.metadataSemaphore.acquire();
        }
        catch (InterruptedException e) {
            this.logger.warn("metadata refresh thread has been interrupted unexpectedly while waiting for update.", (Throwable)e);
        }
    }

    public Map<String, MetadataInfo> getMetadataInfos() {
        return this.metadataInfos;
    }

    boolean addURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            SortedSet urls = serviceURLs.computeIfAbsent(url.getServiceKey(), this::newSortedURLs);
            return urls.add(url);
        });
    }

    boolean removeURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            String key = url.getServiceKey();
            SortedSet urls = serviceURLs.getOrDefault(key, null);
            if (urls == null) {
                return true;
            }
            boolean r = urls.remove(url);
            if (urls.isEmpty()) {
                serviceURLs.remove(key);
            }
            return r;
        });
    }

    private SortedSet<URL> newSortedURLs(String serviceKey) {
        return new TreeSet<URL>(URLComparator.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeMutually(Callable<Boolean> callable) {
        boolean success = false;
        try {
            this.lock.lock();
            try {
                success = callable.call();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return success;
    }

    private SortedSet<String> getServiceURLs(Map<String, SortedSet<URL>> exportedServiceURLs, String serviceKey, String protocol) {
        SortedSet<URL> serviceURLs = exportedServiceURLs.get(serviceKey);
        if (CollectionUtils.isEmpty(serviceURLs)) {
            return Collections.emptySortedSet();
        }
        return MetadataService.toSortedStrings(serviceURLs.stream().filter(url -> this.isAcceptableProtocol(protocol, (URL)url)));
    }

    private boolean isAcceptableProtocol(String protocol, URL url) {
        return protocol == null || protocol.equals(url.getParameter("protocol")) || protocol.equals(url.getProtocol());
    }

    static class URLComparator
    implements Comparator<URL> {
        public static final URLComparator INSTANCE = new URLComparator();

        URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toFullString().compareTo(o2.toFullString());
        }
    }
}

