/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarScanner {
    private static final String PACKAGE_NAME_PREFIX = "org/apache/dubbo";
    private final Map<String, String> classNameCache = new HashMap<String, String>();
    private Map<String, Class<?>> classesCache;
    private final List<String> resourcePathCache = new ArrayList<String>();

    protected Map<String, Class<?>> getClasses() {
        if (this.classesCache == null || this.classesCache.size() == 0) {
            this.classesCache = this.forNames(this.classNameCache.values());
        }
        return this.classesCache;
    }

    public JarScanner() {
        this.scanURL(PACKAGE_NAME_PREFIX);
    }

    protected Map<String, Class<?>> forNames(Collection<String> classNames) {
        HashMap classes = new HashMap();
        classNames.forEach(it -> {
            try {
                Class<?> c = Class.forName(it);
                classes.put((String)it, c);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        return classes;
    }

    private void scanURL(String prefixName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(prefixName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String protocol = resource.getProtocol();
                if ("file".equals(protocol)) {
                    this.scanFile(resource.getPath());
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)resource.openConnection()).getJarFile();
                try {
                    this.scanJar(jar);
                }
                finally {
                    if (jar == null) continue;
                    jar.close();
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void scanFile(String resource) {
        File directory = new File(resource);
        File[] listFiles = directory.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    this.scanFile(file.getPath());
                    continue;
                }
                String path = file.getPath();
                if (!this.matchedDubboClasses(path)) continue;
                this.classNameCache.put(path, this.toClassName(path));
            }
        }
    }

    private void scanJar(JarFile jar) {
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry jarEntry = entry.nextElement();
            String name = jarEntry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (jarEntry.isDirectory()) continue;
            if (this.matchedDubboClasses(name)) {
                this.classNameCache.put(name, this.toClassName(name));
                continue;
            }
            this.resourcePathCache.add(name);
        }
    }

    protected List<String> getResourcePath() {
        return this.resourcePathCache;
    }

    private boolean matchedDubboClasses(String path) {
        return path.startsWith(PACKAGE_NAME_PREFIX) && path.endsWith(".class");
    }

    private String toClassName(String path) {
        return path.contains(File.separator) ? path.substring(0, path.length() - 6).replace(File.separator, ".") : path.substring(0, path.length() - 6).replace("/", ".");
    }
}

