/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.api.ExecutableDescriber;
import org.apache.dubbo.aot.api.ExecutableMode;
import org.apache.dubbo.aot.api.FieldDescriber;
import org.apache.dubbo.aot.api.MemberCategory;
import org.apache.dubbo.aot.api.TypeDescriber;
import org.apache.dubbo.aot.generate.BasicJsonWriter;
import org.apache.dubbo.aot.generate.ReflectConfigMetadataRepository;

public class ReflectionConfigWriter {
    public static final ReflectionConfigWriter INSTANCE = new ReflectionConfigWriter();

    public void write(BasicJsonWriter writer, ReflectConfigMetadataRepository repository) {
        writer.writeArray(repository.getTypes().stream().map(this::toAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> toAttributes(TypeDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", describer.getName());
        this.handleCondition(attributes, describer);
        this.handleCategories(attributes, describer.getMemberCategories());
        this.handleFields(attributes, describer.getFields());
        this.handleExecutables(attributes, describer.getConstructors());
        this.handleExecutables(attributes, describer.getMethods());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, TypeDescriber describer) {
        if (describer.getReachableType() != null) {
            LinkedHashMap<String, String> conditionAttributes = new LinkedHashMap<String, String>();
            conditionAttributes.put("typeReachable", describer.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }

    private void handleFields(Map<String, Object> attributes, Set<FieldDescriber> fieldDescribers) {
        this.addIfNotEmpty(attributes, "fields", fieldDescribers.stream().map(this::toAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> toAttributes(FieldDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", describer.getName());
        return attributes;
    }

    private void handleExecutables(Map<String, Object> attributes, Set<ExecutableDescriber> executableDescribers) {
        this.addIfNotEmpty(attributes, "methods", executableDescribers.stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INVOKE)).map(this::toAttributes).collect(Collectors.toList()));
        this.addIfNotEmpty(attributes, "queriedMethods", executableDescribers.stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INTROSPECT)).map(this::toAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> toAttributes(ExecutableDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", describer.getName());
        attributes.put("parameterTypes", describer.getParameterTypes());
        return attributes;
    }

    private void handleCategories(Map<String, Object> attributes, Set<MemberCategory> categories) {
        categories.forEach(category -> {
            switch (category) {
                case PUBLIC_FIELDS: {
                    attributes.put("allPublicFields", true);
                    break;
                }
                case DECLARED_FIELDS: {
                    attributes.put("allDeclaredFields", true);
                    break;
                }
                case INTROSPECT_PUBLIC_CONSTRUCTORS: {
                    attributes.put("queryAllPublicConstructors", true);
                    break;
                }
                case INTROSPECT_DECLARED_CONSTRUCTORS: {
                    attributes.put("queryAllDeclaredConstructors", true);
                    break;
                }
                case INVOKE_PUBLIC_CONSTRUCTORS: {
                    attributes.put("allPublicConstructors", true);
                    break;
                }
                case INVOKE_DECLARED_CONSTRUCTORS: {
                    attributes.put("allDeclaredConstructors", true);
                    break;
                }
                case INTROSPECT_PUBLIC_METHODS: {
                    attributes.put("queryAllPublicMethods", true);
                    break;
                }
                case INTROSPECT_DECLARED_METHODS: {
                    attributes.put("queryAllDeclaredMethods", true);
                    break;
                }
                case INVOKE_PUBLIC_METHODS: {
                    attributes.put("allPublicMethods", true);
                    break;
                }
                case INVOKE_DECLARED_METHODS: {
                    attributes.put("allDeclaredMethods", true);
                    break;
                }
                case PUBLIC_CLASSES: {
                    attributes.put("allPublicClasses", true);
                    break;
                }
                case DECLARED_CLASSES: {
                    attributes.put("allDeclaredClasses", true);
                    break;
                }
            }
        });
    }

    private void addIfNotEmpty(Map<String, Object> attributes, String name, Object value) {
        if (value instanceof Collection && ((Collection)value).size() != 0) {
            attributes.put(name, value);
        }
    }
}

