/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mutiny.handler;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.mutiny.calls.MutinyServerCalls;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;
import org.apache.dubbo.rpc.stub.StubMethodHandler;

public class ManyToOneMethodHandler<T, R>
implements StubMethodHandler<T, R> {
    private final Function<Multi<T>, Uni<R>> func;

    public ManyToOneMethodHandler(Function<Multi<T>, Uni<R>> func) {
        this.func = func;
    }

    public CompletableFuture<StreamObserver<T>> invoke(Object[] arguments) {
        CallStreamObserver responseObserver = (CallStreamObserver)arguments[0];
        StreamObserver<T> requestObserver = MutinyServerCalls.manyToOne(responseObserver, this.func);
        return CompletableFuture.completedFuture(requestObserver);
    }
}

