/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.ScaleFunction;
import com.tdunning.math.stats.Sort;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.metrics.aggregate.DubboAbstractTDigest;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;

public class DubboMergingDigest
extends DubboAbstractTDigest {
    private int mergeCount = 0;
    private final double publicCompression;
    private final double compression;
    private final AtomicInteger lastUsedCell = new AtomicInteger(0);
    private double totalWeight = 0.0;
    private final double[] weight;
    private final double[] mean;
    private List<List<Double>> data = null;
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;
    private AtomicInteger unmergedWeight = new AtomicInteger(0);
    private final AtomicInteger tempUsed = new AtomicInteger(0);
    private final double[] tempWeight;
    private final double[] tempMean;
    private List<List<Double>> tempData = null;
    private final int[] order;
    public boolean useAlternatingSort = true;
    public boolean useTwoLevelCompression = true;
    public static boolean useWeightLimit = true;

    public DubboMergingDigest(double compression) {
        this(compression, -1);
    }

    public DubboMergingDigest(double compression, int bufferSize) {
        this(compression, bufferSize, -1);
    }

    public DubboMergingDigest(double compression, int bufferSize, int size) {
        if (compression < 10.0) {
            compression = 10.0;
        }
        double sizeFudge = 0.0;
        if (useWeightLimit) {
            sizeFudge = 10.0;
            if (compression < 30.0) {
                sizeFudge += 20.0;
            }
        }
        size = (int)Math.max(2.0 * compression + sizeFudge, (double)size);
        if (bufferSize == -1) {
            bufferSize = 5 * size;
        }
        if (bufferSize <= 2 * size) {
            bufferSize = 2 * size;
        }
        double scale = Math.max(1, bufferSize / size - 1);
        if (!this.useTwoLevelCompression) {
            scale = 1.0;
        }
        this.publicCompression = compression;
        this.compression = Math.sqrt(scale) * this.publicCompression;
        if ((double)size < this.compression + sizeFudge) {
            size = (int)Math.ceil(this.compression + sizeFudge);
        }
        if (bufferSize <= 2 * size) {
            bufferSize = 2 * size;
        }
        this.weight = new double[size];
        this.mean = new double[size];
        this.tempWeight = new double[bufferSize];
        this.tempMean = new double[bufferSize];
        this.order = new int[bufferSize];
        this.lastUsedCell.set(0);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public TDigest recordAllData() {
        super.recordAllData();
        this.data = new ArrayList<List<Double>>();
        this.tempData = new ArrayList<List<Double>>();
        return this;
    }

    @Override
    void add(double x, int w, Centroid base) {
        this.add(x, w, base.data());
    }

    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(double x, int w, List<Double> history) {
        int where;
        if (Double.isNaN(x)) {
            return;
        }
        DubboMergingDigest dubboMergingDigest = this;
        synchronized (dubboMergingDigest) {
            if (this.tempUsed.get() >= this.tempWeight.length - this.lastUsedCell.get() - 1) {
                this.mergeNewValues();
            }
            where = this.tempUsed.getAndIncrement();
            this.tempWeight[where] = w;
            this.tempMean[where] = x;
            this.unmergedWeight.addAndGet(w);
        }
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        if (this.data != null) {
            if (this.tempData == null) {
                this.tempData = new ArrayList<List<Double>>();
            }
            while (this.tempData.size() <= where) {
                this.tempData.add(new ArrayList());
            }
            if (history == null) {
                history = Collections.singletonList(x);
            }
            this.tempData.get(where).addAll(history);
        }
    }

    public void add(List<? extends TDigest> others) {
        throw new MetricsNeverHappenException("Method not used");
    }

    private void mergeNewValues() {
        this.mergeNewValues(false, this.compression);
    }

    private void mergeNewValues(boolean force, double compression) {
        if (this.totalWeight == 0.0 && this.unmergedWeight.get() == 0) {
            return;
        }
        if (force || this.unmergedWeight.get() > 0) {
            this.merge(this.tempMean, this.tempWeight, this.tempUsed.get(), this.tempData, this.order, this.unmergedWeight.get(), this.useAlternatingSort & this.mergeCount % 2 == 1, compression);
            ++this.mergeCount;
            this.tempUsed.set(0);
            this.unmergedWeight.set(0);
            if (this.data != null) {
                this.tempData = new ArrayList<List<Double>>();
            }
        }
    }

    private void merge(double[] incomingMean, double[] incomingWeight, int incomingCount, List<List<Double>> incomingData, int[] incomingOrder, double unmergedWeight, boolean runBackwards, double compression) {
        assert (this.lastUsedCell.get() <= 0 || this.weight[0] == 1.0);
        assert (this.lastUsedCell.get() <= 0 || this.weight[this.lastUsedCell.get() - 1] == 1.0);
        System.arraycopy(this.mean, 0, incomingMean, incomingCount, this.lastUsedCell.get());
        System.arraycopy(this.weight, 0, incomingWeight, incomingCount, this.lastUsedCell.get());
        incomingCount += this.lastUsedCell.get();
        if (incomingData != null) {
            for (int i = 0; i < this.lastUsedCell.get(); ++i) {
                assert (this.data != null);
                incomingData.add(this.data.get(i));
            }
            this.data = new ArrayList<List<Double>>();
        }
        if (incomingOrder == null) {
            incomingOrder = new int[incomingCount];
        }
        Sort.stableSort((int[])incomingOrder, (double[])incomingMean, (int)incomingCount);
        this.totalWeight += unmergedWeight;
        if (runBackwards) {
            Sort.reverse((int[])incomingOrder, (int)0, (int)incomingCount);
        }
        this.lastUsedCell.set(0);
        this.mean[this.lastUsedCell.get()] = incomingMean[incomingOrder[0]];
        this.weight[this.lastUsedCell.get()] = incomingWeight[incomingOrder[0]];
        double wSoFar = 0.0;
        if (this.data != null) {
            assert (incomingData != null);
            this.data.add(incomingData.get(incomingOrder[0]));
        }
        double normalizer = this.scale.normalizer(compression, this.totalWeight);
        double k1 = this.scale.k(0.0, normalizer);
        double wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
        for (int i = 1; i < incomingCount; ++i) {
            boolean addThis;
            int ix = incomingOrder[i];
            double proposedWeight = this.weight[this.lastUsedCell.get()] + incomingWeight[ix];
            double projectedW = wSoFar + proposedWeight;
            if (useWeightLimit) {
                double q0 = wSoFar / this.totalWeight;
                double q2 = (wSoFar + proposedWeight) / this.totalWeight;
                addThis = proposedWeight <= this.totalWeight * Math.min(this.scale.max(q0, normalizer), this.scale.max(q2, normalizer));
            } else {
                boolean bl = addThis = projectedW <= wLimit;
            }
            if (i == 1 || i == incomingCount - 1) {
                addThis = false;
            }
            if (addThis) {
                int n = this.lastUsedCell.get();
                this.weight[n] = this.weight[n] + incomingWeight[ix];
                this.mean[this.lastUsedCell.get()] = this.mean[this.lastUsedCell.get()] + (incomingMean[ix] - this.mean[this.lastUsedCell.get()]) * incomingWeight[ix] / this.weight[this.lastUsedCell.get()];
                incomingWeight[ix] = 0.0;
                if (this.data == null) continue;
                while (this.data.size() <= this.lastUsedCell.get()) {
                    this.data.add(new ArrayList());
                }
                assert (incomingData != null);
                assert (this.data.get(this.lastUsedCell.get()) != incomingData.get(ix));
                this.data.get(this.lastUsedCell.get()).addAll((Collection<Double>)incomingData.get(ix));
                continue;
            }
            wSoFar += this.weight[this.lastUsedCell.get()];
            if (!useWeightLimit) {
                k1 = this.scale.k(wSoFar / this.totalWeight, normalizer);
                wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
            }
            this.lastUsedCell.getAndIncrement();
            this.mean[this.lastUsedCell.get()] = incomingMean[ix];
            this.weight[this.lastUsedCell.get()] = incomingWeight[ix];
            incomingWeight[ix] = 0.0;
            if (this.data == null) continue;
            assert (incomingData != null);
            assert (this.data.size() == this.lastUsedCell.get());
            this.data.add(incomingData.get(ix));
        }
        this.lastUsedCell.getAndIncrement();
        double sum = 0.0;
        for (int i = 0; i < this.lastUsedCell.get(); ++i) {
            sum += this.weight[i];
        }
        assert (sum == this.totalWeight);
        if (runBackwards) {
            Sort.reverse((double[])this.mean, (int)0, (int)this.lastUsedCell.get());
            Sort.reverse((double[])this.weight, (int)0, (int)this.lastUsedCell.get());
            if (this.data != null) {
                Collections.reverse(this.data);
            }
        }
        assert (this.weight[0] == 1.0);
        assert (this.weight[this.lastUsedCell.get() - 1] == 1.0);
        if (this.totalWeight > 0.0) {
            this.min = Math.min(this.min, this.mean[0]);
            this.max = Math.max(this.max, this.mean[this.lastUsedCell.get() - 1]);
        }
    }

    public void compress() {
        this.mergeNewValues(true, this.publicCompression);
    }

    public long size() {
        return (long)(this.totalWeight + (double)this.unmergedWeight.get());
    }

    public double cdf(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new IllegalArgumentException(String.format("Invalid value: %f", x));
        }
        this.mergeNewValues();
        if (this.lastUsedCell.get() == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell.get() == 1) {
            double width = this.max - this.min;
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            if (x - this.min <= width) {
                return 0.5;
            }
            return (x - this.min) / (this.max - this.min);
        }
        int n = this.lastUsedCell.get();
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 1.0;
        }
        if (x < this.mean[0]) {
            if (this.mean[0] - this.min > 0.0) {
                if (x == this.min) {
                    return 0.5 / this.totalWeight;
                }
                return (1.0 + (x - this.min) / (this.mean[0] - this.min) * (this.weight[0] / 2.0 - 1.0)) / this.totalWeight;
            }
            return 0.0;
        }
        assert (x >= this.mean[0]);
        if (x > this.mean[n - 1]) {
            if (this.max - this.mean[n - 1] > 0.0) {
                if (x == this.max) {
                    return 1.0 - 0.5 / this.totalWeight;
                }
                double dq = (1.0 + (this.max - x) / (this.max - this.mean[n - 1]) * (this.weight[n - 1] / 2.0 - 1.0)) / this.totalWeight;
                return 1.0 - dq;
            }
            return 1.0;
        }
        double weightSoFar = 0.0;
        for (int it = 0; it < n - 1; ++it) {
            if (this.mean[it] == x) {
                double dw = 0.0;
                while (it < n && this.mean[it] == x) {
                    dw += this.weight[it];
                    ++it;
                }
                return (weightSoFar + dw / 2.0) / this.totalWeight;
            }
            if (this.mean[it] <= x && x < this.mean[it + 1]) {
                if (this.mean[it + 1] - this.mean[it] > 0.0) {
                    double leftExcludedW = 0.0;
                    double rightExcludedW = 0.0;
                    if (this.weight[it] == 1.0) {
                        if (this.weight[it + 1] == 1.0) {
                            return (weightSoFar + 1.0) / this.totalWeight;
                        }
                        leftExcludedW = 0.5;
                    } else if (this.weight[it + 1] == 1.0) {
                        rightExcludedW = 0.5;
                    }
                    double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                    assert (dw > 1.0);
                    assert (leftExcludedW + rightExcludedW <= 0.5);
                    double left = this.mean[it];
                    double right = this.mean[it + 1];
                    double dwNoSingleton = dw - leftExcludedW - rightExcludedW;
                    assert (dwNoSingleton > dw / 2.0);
                    assert (right - left > 0.0);
                    double base = weightSoFar + this.weight[it] / 2.0 + leftExcludedW;
                    return (base + dwNoSingleton * (x - left) / (right - left)) / this.totalWeight;
                }
                double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                return (weightSoFar + dw) / this.totalWeight;
            }
            weightSoFar += this.weight[it];
        }
        if (x == this.mean[n - 1]) {
            return 1.0 - 0.5 / this.totalWeight;
        }
        throw new IllegalStateException("Can't happen ... loop fell through");
    }

    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        this.mergeNewValues();
        if (this.lastUsedCell.get() == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell.get() == 1) {
            return this.mean[0];
        }
        int n = this.lastUsedCell.get();
        double index = q * this.totalWeight;
        if (index < 1.0) {
            return this.min;
        }
        if (this.weight[0] > 1.0 && index < this.weight[0] / 2.0) {
            return this.min + (index - 1.0) / (this.weight[0] / 2.0 - 1.0) * (this.mean[0] - this.min);
        }
        if (index > this.totalWeight - 1.0) {
            return this.max;
        }
        if (this.weight[n - 1] > 1.0 && this.totalWeight - index <= this.weight[n - 1] / 2.0) {
            return this.max - (this.totalWeight - index - 1.0) / (this.weight[n - 1] / 2.0 - 1.0) * (this.max - this.mean[n - 1]);
        }
        double weightSoFar = this.weight[0] / 2.0;
        for (int i = 0; i < n - 1; ++i) {
            double dw = (this.weight[i] + this.weight[i + 1]) / 2.0;
            if (weightSoFar + dw > index) {
                double leftUnit = 0.0;
                if (this.weight[i] == 1.0) {
                    if (index - weightSoFar < 0.5) {
                        return this.mean[i];
                    }
                    leftUnit = 0.5;
                }
                double rightUnit = 0.0;
                if (this.weight[i + 1] == 1.0) {
                    if (weightSoFar + dw - index <= 0.5) {
                        return this.mean[i + 1];
                    }
                    rightUnit = 0.5;
                }
                double z1 = index - weightSoFar - leftUnit;
                double z2 = weightSoFar + dw - index - rightUnit;
                return DubboMergingDigest.weightedAverage(this.mean[i], z2, this.mean[i + 1], z1);
            }
            weightSoFar += dw;
        }
        assert (this.weight[n - 1] > 1.0);
        assert (index <= this.totalWeight);
        assert (index >= this.totalWeight - this.weight[n - 1] / 2.0);
        double z1 = index - this.totalWeight - this.weight[n - 1] / 2.0;
        double z2 = this.weight[n - 1] / 2.0 - z1;
        return DubboMergingDigest.weightedAverage(this.mean[n - 1], z1, this.max, z2);
    }

    public int centroidCount() {
        this.mergeNewValues();
        return this.lastUsedCell.get();
    }

    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < DubboMergingDigest.this.lastUsedCell.get();
                    }

                    @Override
                    public Centroid next() {
                        List datas;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Centroid rc = new Centroid(DubboMergingDigest.this.mean[this.i], (int)DubboMergingDigest.this.weight[this.i]);
                        List list = datas = DubboMergingDigest.this.data != null ? (List)DubboMergingDigest.this.data.get(this.i) : null;
                        if (datas != null) {
                            datas.forEach(arg_0 -> ((Centroid)rc).insertData(arg_0));
                        }
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return DubboMergingDigest.this.lastUsedCell.get();
            }
        };
    }

    public double compression() {
        return this.publicCompression;
    }

    public int byteSize() {
        this.compress();
        return this.lastUsedCell.get() * 16 + 32;
    }

    public int smallByteSize() {
        this.compress();
        return this.lastUsedCell.get() * 8 + 30;
    }

    public ScaleFunction getScaleFunction() {
        return this.scale;
    }

    public void setScaleFunction(ScaleFunction scaleFunction) {
        super.setScaleFunction(scaleFunction);
    }

    public void asBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.VERBOSE_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putDouble(this.publicCompression);
        buf.putInt(this.lastUsedCell.get());
        for (int i = 0; i < this.lastUsedCell.get(); ++i) {
            buf.putDouble(this.weight[i]);
            buf.putDouble(this.mean[i]);
        }
    }

    public void asSmallBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.SMALL_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putFloat((float)this.publicCompression);
        buf.putShort((short)this.mean.length);
        buf.putShort((short)this.tempMean.length);
        buf.putShort((short)this.lastUsedCell.get());
        for (int i = 0; i < this.lastUsedCell.get(); ++i) {
            buf.putFloat((float)this.weight[i]);
            buf.putFloat((float)this.mean[i]);
        }
    }

    public String toString() {
        return "MergingDigest-" + this.getScaleFunction() + "-" + (useWeightLimit ? "weight" : "kSize") + "-" + (this.useAlternatingSort ? "alternating" : "stable") + "-" + (this.useTwoLevelCompression ? "twoLevel" : "oneLevel");
    }

    public static enum Encoding {
        VERBOSE_ENCODING(1),
        SMALL_ENCODING(2);

        private final int code;

        private Encoding(int code) {
            this.code = code;
        }
    }
}

