/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.store.MetadataReport;
import org.apache.dubbo.metadata.store.MetadataReportFactory;

public abstract class AbstractMetadataReportFactory
implements MetadataReportFactory {
    private static final String EXPORT_KEY = "export";
    private static final String REFER_KEY = "refer";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, MetadataReport> SERVICE_STORE_MAP = new ConcurrentHashMap<String, MetadataReport>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataReport getMetadataReport(URL url) {
        url = url.setPath(MetadataReport.class.getName()).removeParameters(new String[]{EXPORT_KEY, REFER_KEY});
        String key = url.toServiceString();
        LOCK.lock();
        try {
            MetadataReport metadataReport = SERVICE_STORE_MAP.get(key);
            if (metadataReport != null) {
                MetadataReport metadataReport2 = metadataReport;
                return metadataReport2;
            }
            metadataReport = this.createMetadataReport(url);
            if (metadataReport == null) {
                throw new IllegalStateException("Can not create metadata Report " + url);
            }
            SERVICE_STORE_MAP.put(key, metadataReport);
            MetadataReport metadataReport3 = metadataReport;
            return metadataReport3;
        }
        finally {
            LOCK.unlock();
        }
    }

    protected abstract MetadataReport createMetadataReport(URL var1);
}

