/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.dubbo.metadata.annotation.processing.ClassPathMetadataStorage;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;

public class ServiceRestMetadataStorage {
    private final ClassPathMetadataStorage storage;

    public ServiceRestMetadataStorage(ProcessingEnvironment processingEnv) {
        this.storage = new ClassPathMetadataStorage(processingEnv);
    }

    public void append(Set<ServiceRestMetadata> serviceRestMetadata) throws IOException {
        this.storage.read("META-INF/dubbo/service-rest-metadata.json", reader -> {
            Gson gson = new Gson();
            return (List)gson.fromJson(reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{ServiceRestMetadata.class}).getType());
        }).ifPresent(existedMetadata -> serviceRestMetadata.addAll((Collection<ServiceRestMetadata>)existedMetadata));
        this.write(serviceRestMetadata);
    }

    public void write(Set<ServiceRestMetadata> serviceRestMetadata) throws IOException {
        if (serviceRestMetadata.isEmpty()) {
            return;
        }
        this.storage.write(() -> new Gson().toJson((Object)serviceRestMetadata), "META-INF/dubbo/service-rest-metadata.json");
    }
}

