/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.rest.AnnotatedMethodParameterProcessor;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;

public abstract class AbstractAnnotatedMethodParameterProcessor
implements AnnotatedMethodParameterProcessor {
    @Override
    public void process(Annotation annotation, Parameter parameter, int parameterIndex, Method method, Class<?> serviceType, Class<?> serviceInterfaceClass, RestMethodMetadata restMethodMetadata) {
        String annotationValue = this.getAnnotationValue(annotation, parameter, parameterIndex);
        String defaultValue = this.getDefaultValue(annotation, parameter, parameterIndex);
        this.addArgInfo(parameter, parameterIndex, restMethodMetadata, annotationValue, defaultValue);
        this.process(annotationValue, defaultValue, annotation, parameter, parameterIndex, method, restMethodMetadata);
    }

    protected void process(String annotationValue, String defaultValue, Annotation annotation, Parameter parameter, int parameterIndex, Method method, RestMethodMetadata restMethodMetadata) {
    }

    @Override
    public Class getAnnotationClass() {
        return ClassUtils.resolveClass((String)this.getAnnotationName(), (ClassLoader)ClassUtils.getClassLoader());
    }

    protected void addArgInfo(Parameter parameter, int parameterIndex, RestMethodMetadata restMethodMetadata, String annotationValue, Object defaultValue) {
        ArgInfo argInfo = ArgInfo.build(parameterIndex, parameter).setParamAnnotationType(this.getAnnotationClass()).setAnnotationNameAttribute(annotationValue).setDefaultValue(defaultValue);
        restMethodMetadata.addArgInfo(argInfo);
    }

    protected String getAnnotationValue(Annotation annotation, Parameter parameter, int parameterIndex) {
        return (String)AnnotationUtils.getValue((Annotation)annotation);
    }

    protected String getDefaultValue(Annotation annotation, Parameter parameter, int parameterIndex) {
        return AnnotatedMethodParameterProcessor.buildDefaultValue(parameterIndex);
    }
}

