/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.protoc.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPlugin;
import org.apache.dubbo.maven.plugin.protoc.ProtocMetaData;
import org.apache.dubbo.maven.plugin.protoc.command.ProtocCommandArgsBuilder;

public class DefaultProtocCommandBuilder
implements ProtocCommandArgsBuilder {
    @Override
    public List<String> buildProtocCommandArgs(ProtocMetaData protocMetaData) {
        ArrayList<String> command = new ArrayList<String>();
        for (File protoSourceDir : protocMetaData.getProtoSourceDirs()) {
            command.add("--proto_path=" + protoSourceDir);
        }
        String outputOption = "--java_out=";
        outputOption = outputOption + protocMetaData.getOutputDir();
        command.add(outputOption);
        DubboProtocPlugin dubboProtocPlugin = protocMetaData.getDubboProtocPlugin();
        command.add("--plugin=protoc-gen-" + dubboProtocPlugin.getId() + '=' + dubboProtocPlugin.getProtocPlugin());
        command.add("--" + dubboProtocPlugin.getId() + "_out=" + protocMetaData.getOutputDir());
        for (File protoFile : protocMetaData.getProtoFiles()) {
            command.add(protoFile.toString());
        }
        return command;
    }
}

