/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.aot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.dubbo.maven.plugin.aot.Exclude;
import org.apache.dubbo.maven.plugin.aot.ExcludeFilter;
import org.apache.dubbo.maven.plugin.aot.Include;
import org.apache.dubbo.maven.plugin.aot.IncludeFilter;
import org.apache.dubbo.maven.plugin.aot.MatchingGroupIdFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactFeatureFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;

public abstract class AbstractDependencyFilterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="dubbo.includes")
    private List<Include> includes;
    @Parameter(property="dubbo.excludes")
    private List<Exclude> excludes;
    @Parameter(property="dubbo.excludeGroupIds", defaultValue="")
    private String excludeGroupIds;

    protected void setExcludes(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    protected void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    protected void setExcludeGroupIds(String excludeGroupIds) {
        this.excludeGroupIds = excludeGroupIds;
    }

    protected List<URL> getDependencyURLs(ArtifactsFilter ... additionalFilters) throws MojoExecutionException {
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), additionalFilters);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(this.toURL(artifact.getFile()));
        }
        return urls;
    }

    protected final Set<Artifact> filterDependencies(Set<Artifact> dependencies, ArtifactsFilter ... additionalFilters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(this.getFilters(additionalFilters).filter(dependencies));
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid URL for " + file, ex);
        }
    }

    private FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        filters.addFilter((ArtifactsFilter)new MatchingGroupIdFilter(this.cleanFilterConfig(this.excludeGroupIds)));
        if (this.includes != null && !this.includes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        }
        return filters;
    }

    private String cleanFilterConfig(String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        StringBuilder cleaned = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            cleaned.append(tokenizer.nextToken().trim());
            if (!tokenizer.hasMoreElements()) continue;
            cleaned.append(",");
        }
        return cleaned.toString();
    }

    protected static class ExcludeTestScopeArtifactFilter
    extends AbstractArtifactFeatureFilter {
        ExcludeTestScopeArtifactFilter() {
            super("", "test");
        }

        protected String getArtifactFeature(Artifact artifact) {
            return artifact.getScope();
        }
    }
}

