/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;

public class AotUtils {
    private AotUtils() {
    }

    public static void registerSerializationForService(Class<?> serviceType, RuntimeHints hints) {
        LinkedHashSet serializationTypeCache = new LinkedHashSet();
        Arrays.stream(serviceType.getMethods()).forEach(method -> {
            Arrays.stream(method.getParameterTypes()).forEach(parameterType -> AotUtils.registerSerializationType(parameterType, hints, serializationTypeCache));
            AotUtils.registerSerializationType(method.getReturnType(), hints, serializationTypeCache);
        });
    }

    private static void registerSerializationType(Class<?> registerType, RuntimeHints hints, Set<Class<?>> serializationTypeCache) {
        if (AotUtils.isPrimitive(registerType)) {
            hints.serialization().registerType(TypeReference.of((Class)ClassUtils.getBoxedClass(registerType)));
            serializationTypeCache.add(registerType);
        } else if (Serializable.class.isAssignableFrom(registerType)) {
            hints.serialization().registerType(TypeReference.of(registerType));
            serializationTypeCache.add(registerType);
            Arrays.stream(registerType.getDeclaredFields()).forEach(field -> {
                if (!serializationTypeCache.contains(field.getType())) {
                    AotUtils.registerSerializationType(field.getType(), hints, serializationTypeCache);
                    serializationTypeCache.add(field.getType());
                }
            });
            if (registerType.getSuperclass() != null) {
                AotUtils.registerSerializationType(registerType.getSuperclass(), hints, serializationTypeCache);
            }
        }
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == Date.class || cls == Class.class;
    }
}

