/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DubboConfigBeanInitializer
implements BeanFactoryAware,
InitializingBean {
    public static String BEAN_NAME = "dubboConfigBeanInitializer";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ConfigurableListableBeanFactory beanFactory;
    private ReferenceBeanManager referenceBeanManager;
    private ConfigManager configManager;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.configManager = ApplicationModel.getConfigManager();
            this.referenceBeanManager = (ReferenceBeanManager)this.beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
            try {
                this.prepareDubboConfigBeans();
                this.referenceBeanManager.prepareReferenceBeans();
            }
            catch (Throwable e) {
                throw new FatalBeanException("Initialization dubbo config beans failed", e);
            }
        }
    }

    private void prepareDubboConfigBeans() {
        this.logger.info((Object)"loading dubbo config beans ...");
        this.loadConfigBeansOfType(ApplicationConfig.class);
        this.loadConfigBeansOfType(ModuleConfig.class);
        this.loadConfigBeansOfType(RegistryConfig.class);
        this.loadConfigBeansOfType(ProtocolConfig.class);
        this.loadConfigBeansOfType(MonitorConfig.class);
        this.loadConfigBeansOfType(ProviderConfig.class);
        this.loadConfigBeansOfType(ConsumerConfig.class);
        this.loadConfigBeansOfType(ConfigCenterBean.class);
        this.loadConfigBeansOfType(MetadataReportConfig.class);
        this.loadConfigBeansOfType(MetricsConfig.class);
        this.loadConfigBeansOfType(SslConfig.class);
        this.logger.info((Object)"dubbo config beans are loaded.");
    }

    private void loadConfigBeansOfType(Class<? extends AbstractConfig> configClass) {
        String[] beanNames;
        for (String beanName : beanNames = this.beanFactory.getBeanNamesForType(configClass, true, false)) {
            AbstractConfig configBean = (AbstractConfig)this.beanFactory.getBean(beanName, configClass);
            this.configManager.addConfig(configBean);
        }
    }
}

