/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import com.alibaba.spring.util.BeanRegistrar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.spring.beans.factory.annotation.DubboConfigAliasPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.config.DubboConfigDefaultPropertyValueBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.config.DubboConfigEarlyInitializationPostProcessor;
import org.apache.dubbo.config.spring.context.DubboApplicationListenerRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ObjectUtils;

public abstract class DubboBeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(DubboBeanUtils.class);

    public static void registerCommonBeans(BeanDefinitionRegistry registry) {
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class);
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"dubboConfigAliasPostProcessor", DubboConfigAliasPostProcessor.class);
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"dubboApplicationListenerRegister", DubboApplicationListenerRegistrar.class);
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"dubboConfigDefaultPropertyValueBeanPostProcessor", DubboConfigDefaultPropertyValueBeanPostProcessor.class);
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"dubboConfigEarlyInitializationPostProcessor", DubboConfigEarlyInitializationPostProcessor.class);
    }

    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) throws BeansException {
        if (beanName == null) {
            return DubboBeanUtils.getOptionalBeanByType(beanFactory, beanType);
        }
        Object bean = null;
        try {
            bean = beanFactory.getBean(beanName, beanType);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
        }
        catch (BeanNotOfRequiredTypeException e) {
            logger.warn(String.format("bean type not match, name: %s, expected type: %s, actual type: %s", beanName, beanType.getName(), e.getActualType().getName()));
        }
        return (T)bean;
    }

    private static <T> T getOptionalBeanByType(ListableBeanFactory beanFactory, Class<T> beanType) {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanType, (boolean)true, (boolean)false);
        if (beanNames == null || beanNames.length == 0) {
            return null;
        }
        if (beanNames.length > 1) {
            throw new NoUniqueBeanDefinitionException(beanType, Arrays.asList(beanNames));
        }
        return (T)beanFactory.getBean(beanNames[0]);
    }

    public static <T> T getBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) throws BeansException {
        return (T)beanFactory.getBean(beanName, beanType);
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) throws BeansException {
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return Collections.emptyList();
        }
        ArrayList<T> beans = new ArrayList<T>(beanNames.length);
        for (String beanName : beanNames) {
            T bean = DubboBeanUtils.getBean(beanFactory, beanName, beanType);
            if (bean == null) continue;
            beans.add(bean);
        }
        return Collections.unmodifiableList(beans);
    }
}

