/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.bootstrap.BootstrapTakeoverMode;
import org.apache.dubbo.config.bootstrap.DubboBootstrapStartStopListener;
import org.apache.dubbo.config.bootstrap.builders.ApplicationBuilder;
import org.apache.dubbo.config.bootstrap.builders.ConsumerBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProtocolBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProviderBuilder;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.config.bootstrap.builders.RegistryBuilder;
import org.apache.dubbo.config.bootstrap.builders.ServiceBuilder;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.metadata.ConfigurableMetadataServiceExporter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReportFactory;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DubboBootstrap {
    public static final String DEFAULT_REGISTRY_ID = "REGISTRY#DEFAULT";
    public static final String DEFAULT_PROTOCOL_ID = "PROTOCOL#DEFAULT";
    public static final String DEFAULT_SERVICE_ID = "SERVICE#DEFAULT";
    public static final String DEFAULT_REFERENCE_ID = "REFERENCE#DEFAULT";
    public static final String DEFAULT_PROVIDER_ID = "PROVIDER#DEFAULT";
    public static final String DEFAULT_CONSUMER_ID = "CONSUMER#DEFAULT";
    private static final String NAME = DubboBootstrap.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile DubboBootstrap instance;
    private final AtomicBoolean awaited = new AtomicBoolean(false);
    private volatile BootstrapTakeoverMode takeoverMode = BootstrapTakeoverMode.AUTO;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Lock destroyLock = new ReentrantLock();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    private final ConfigManager configManager;
    private final Environment environment;
    private ReferenceConfigCache cache;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean startup = new AtomicBoolean(true);
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile boolean isCurrentlyInStart = false;
    private volatile ServiceInstance serviceInstance;
    private volatile MetadataService metadataService;
    private volatile MetadataServiceExporter metadataServiceExporter;
    private List<ServiceConfigBase<?>> exportedServices = new ArrayList();
    private final List<CompletableFuture<?>> asyncExportingFutures = new ArrayList();
    private final List<CompletableFuture<?>> asyncReferringFutures = new ArrayList();
    private boolean asyncExportFinish = true;
    private boolean asyncReferFinish = true;
    private static boolean ignoreConfigState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DubboBootstrap getInstance() {
        if (instance != null) return instance;
        Class<DubboBootstrap> clazz = DubboBootstrap.class;
        synchronized (DubboBootstrap.class) {
            if (instance != null) return instance;
            instance = new DubboBootstrap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public static void reset() {
        DubboBootstrap.reset(true);
    }

    @Deprecated
    public static void reset(boolean destroy) {
        ConfigUtils.setProperties(null);
        ignoreConfigState = true;
        if (destroy) {
            if (instance != null) {
                instance.destroy();
                instance = null;
            }
            MetadataReportInstance.reset();
            AbstractRegistryFactory.reset();
            ExtensionLoader.destroyAll();
        } else {
            instance = null;
        }
        ApplicationModel.reset();
        ShutdownHookCallbacks.INSTANCE.clear();
    }

    private DubboBootstrap() {
        this.configManager = ApplicationModel.getConfigManager();
        this.environment = ApplicationModel.getEnvironment();
        DubboShutdownHook.getDubboShutdownHook().register();
        ShutdownHookCallbacks.INSTANCE.addCallback(this::destroy);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void unRegisterShutdownHook() {
        DubboShutdownHook.getDubboShutdownHook().unregister();
    }

    private boolean isRegisterConsumerInstance() {
        Boolean registerConsumer = this.getApplication().getRegisterConsumer();
        return Boolean.TRUE.equals(registerConsumer);
    }

    private String getMetadataType() {
        String type = this.getApplication().getMetadataType();
        if (StringUtils.isEmpty((String)type)) {
            type = "local";
        }
        return type;
    }

    public DubboBootstrap metadataReport(MetadataReportConfig metadataReportConfig) {
        this.configManager.addMetadataReport(metadataReportConfig);
        return this;
    }

    public DubboBootstrap metadataReports(List<MetadataReportConfig> metadataReportConfigs) {
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            return this;
        }
        this.configManager.addMetadataReports(metadataReportConfigs);
        return this;
    }

    public DubboBootstrap application(String name) {
        return this.application(name, builder -> {});
    }

    public DubboBootstrap application(String name, Consumer<ApplicationBuilder> consumerBuilder) {
        ApplicationBuilder builder = this.createApplicationBuilder(name);
        consumerBuilder.accept(builder);
        return this.application(builder.build());
    }

    public DubboBootstrap application(ApplicationConfig applicationConfig) {
        this.configManager.setApplication(applicationConfig);
        return this;
    }

    public DubboBootstrap registry(Consumer<RegistryBuilder> consumerBuilder) {
        return this.registry(DEFAULT_REGISTRY_ID, consumerBuilder);
    }

    public DubboBootstrap registry(String id, Consumer<RegistryBuilder> consumerBuilder) {
        RegistryBuilder builder = this.createRegistryBuilder(id);
        consumerBuilder.accept(builder);
        return this.registry(builder.build());
    }

    public DubboBootstrap registry(RegistryConfig registryConfig) {
        this.configManager.addRegistry(registryConfig);
        return this;
    }

    public DubboBootstrap registries(List<RegistryConfig> registryConfigs) {
        if (CollectionUtils.isEmpty(registryConfigs)) {
            return this;
        }
        registryConfigs.forEach(this::registry);
        return this;
    }

    public DubboBootstrap protocol(Consumer<ProtocolBuilder> consumerBuilder) {
        return this.protocol(DEFAULT_PROTOCOL_ID, consumerBuilder);
    }

    public DubboBootstrap protocol(String id, Consumer<ProtocolBuilder> consumerBuilder) {
        ProtocolBuilder builder = this.createProtocolBuilder(id);
        consumerBuilder.accept(builder);
        return this.protocol(builder.build());
    }

    public DubboBootstrap protocol(ProtocolConfig protocolConfig) {
        return this.protocols(Collections.singletonList(protocolConfig));
    }

    public DubboBootstrap protocols(List<ProtocolConfig> protocolConfigs) {
        if (CollectionUtils.isEmpty(protocolConfigs)) {
            return this;
        }
        this.configManager.addProtocols(protocolConfigs);
        return this;
    }

    public <S> DubboBootstrap service(Consumer<ServiceBuilder<S>> consumerBuilder) {
        return this.service(DEFAULT_SERVICE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap service(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
        ServiceBuilder builder = this.createServiceBuilder(id);
        consumerBuilder.accept(builder);
        return this.service(builder.build());
    }

    public DubboBootstrap service(ServiceConfig<?> serviceConfig) {
        serviceConfig.setBootstrap(this);
        this.configManager.addService(serviceConfig);
        return this;
    }

    public DubboBootstrap services(List<ServiceConfig> serviceConfigs) {
        if (CollectionUtils.isEmpty(serviceConfigs)) {
            return this;
        }
        serviceConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addService(arg_0));
        return this;
    }

    public <S> DubboBootstrap reference(Consumer<ReferenceBuilder<S>> consumerBuilder) {
        return this.reference(DEFAULT_REFERENCE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap reference(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
        ReferenceBuilder builder = this.createReferenceBuilder(id);
        consumerBuilder.accept(builder);
        return this.reference(builder.build());
    }

    public DubboBootstrap reference(ReferenceConfig<?> referenceConfig) {
        referenceConfig.setBootstrap(this);
        this.configManager.addReference(referenceConfig);
        return this;
    }

    public DubboBootstrap references(List<ReferenceConfig> referenceConfigs) {
        if (CollectionUtils.isEmpty(referenceConfigs)) {
            return this;
        }
        referenceConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addReference(arg_0));
        return this;
    }

    public DubboBootstrap provider(Consumer<ProviderBuilder> builderConsumer) {
        return this.provider(DEFAULT_PROVIDER_ID, builderConsumer);
    }

    public DubboBootstrap provider(String id, Consumer<ProviderBuilder> builderConsumer) {
        ProviderBuilder builder = this.createProviderBuilder(id);
        builderConsumer.accept(builder);
        return this.provider(builder.build());
    }

    public DubboBootstrap provider(ProviderConfig providerConfig) {
        return this.providers(Collections.singletonList(providerConfig));
    }

    public DubboBootstrap providers(List<ProviderConfig> providerConfigs) {
        if (CollectionUtils.isEmpty(providerConfigs)) {
            return this;
        }
        providerConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addProvider(arg_0));
        return this;
    }

    public DubboBootstrap consumer(Consumer<ConsumerBuilder> builderConsumer) {
        return this.consumer(DEFAULT_CONSUMER_ID, builderConsumer);
    }

    public DubboBootstrap consumer(String id, Consumer<ConsumerBuilder> builderConsumer) {
        ConsumerBuilder builder = this.createConsumerBuilder(id);
        builderConsumer.accept(builder);
        return this.consumer(builder.build());
    }

    public DubboBootstrap consumer(ConsumerConfig consumerConfig) {
        return this.consumers(Collections.singletonList(consumerConfig));
    }

    public DubboBootstrap consumers(List<ConsumerConfig> consumerConfigs) {
        if (CollectionUtils.isEmpty(consumerConfigs)) {
            return this;
        }
        consumerConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addConsumer(arg_0));
        return this;
    }

    public DubboBootstrap configCenter(ConfigCenterConfig configCenterConfig) {
        return this.configCenters(Collections.singletonList(configCenterConfig));
    }

    public DubboBootstrap configCenters(List<ConfigCenterConfig> configCenterConfigs) {
        if (CollectionUtils.isEmpty(configCenterConfigs)) {
            return this;
        }
        this.configManager.addConfigCenters(configCenterConfigs);
        return this;
    }

    public DubboBootstrap monitor(MonitorConfig monitor) {
        this.configManager.setMonitor(monitor);
        return this;
    }

    public DubboBootstrap metrics(MetricsConfig metrics) {
        this.configManager.setMetrics(metrics);
        return this;
    }

    public DubboBootstrap module(ModuleConfig module) {
        this.configManager.setModule(module);
        return this;
    }

    public DubboBootstrap ssl(SslConfig sslConfig) {
        this.configManager.setSsl(sslConfig);
        return this;
    }

    public DubboBootstrap cache(ReferenceConfigCache cache) {
        this.cache = cache;
        return this;
    }

    public ReferenceConfigCache getCache() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        return this.cache;
    }

    public synchronized void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        ApplicationModel.initFrameworkExts();
        this.startConfigCenter();
        this.loadConfigsFromProps();
        this.checkGlobalConfigs();
        this.startMetadataCenter();
        this.initMetadataService();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(NAME + " has been initialized!");
        }
    }

    private void checkGlobalConfigs() {
        List<Class> multipleConfigTypes = Arrays.asList(ApplicationConfig.class, ProtocolConfig.class, RegistryConfig.class, MetadataReportConfig.class, ProviderConfig.class, ConsumerConfig.class, MonitorConfig.class, ModuleConfig.class, MetricsConfig.class, SslConfig.class);
        for (Class configType : multipleConfigTypes) {
            this.checkDefaultAndValidateConfigs(configType);
        }
        LinkedHashMap<Integer, ProtocolConfig> protocolPortMap = new LinkedHashMap<Integer, ProtocolConfig>();
        for (ProtocolConfig protocol : this.configManager.getProtocols()) {
            Integer port = protocol.getPort();
            if (port == null || port == -1) continue;
            ProtocolConfig prevProtocol = (ProtocolConfig)protocolPortMap.get(port);
            if (prevProtocol != null) {
                throw new IllegalStateException("Duplicated port used by protocol configs, port: " + port + ", configs: " + Arrays.asList(prevProtocol, protocol));
            }
            protocolPortMap.put(port, protocol);
        }
        for (ReferenceConfigBase reference : this.configManager.getReferences()) {
            reference.refresh();
        }
        for (ServiceConfigBase service : this.configManager.getServices()) {
            service.refresh();
        }
    }

    private <T extends AbstractConfig> void checkDefaultAndValidateConfigs(Class<T> configType) {
        try {
            if (this.shouldAddDefaultConfig(configType)) {
                AbstractConfig config = (AbstractConfig)configType.newInstance();
                config.refresh();
                if (!this.isNeedValidation(config) || config.isValid()) {
                    this.configManager.addConfig(config);
                } else {
                    this.logger.info("Ignore invalid config: " + config);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Add default config failed: " + configType.getSimpleName(), e);
        }
        Collection configs = this.configManager.getConfigs(configType);
        for (AbstractConfig config : configs) {
            this.validateConfig(config);
        }
        if (this.isRequired(configType) && configs.isEmpty()) {
            throw new IllegalStateException("Default config not found for " + configType.getSimpleName());
        }
    }

    private <T extends AbstractConfig> boolean isNeedValidation(T config) {
        return !(config instanceof MetadataReportConfig);
    }

    private <T extends AbstractConfig> void validateConfig(T config) {
        if (config instanceof ProtocolConfig) {
            ConfigValidationUtils.validateProtocolConfig((ProtocolConfig)config);
        } else if (config instanceof RegistryConfig) {
            ConfigValidationUtils.validateRegistryConfig((RegistryConfig)config);
        } else if (config instanceof MetadataReportConfig) {
            ConfigValidationUtils.validateMetadataConfig((MetadataReportConfig)config);
        } else if (config instanceof ProviderConfig) {
            ConfigValidationUtils.validateProviderConfig((ProviderConfig)config);
        } else if (config instanceof ConsumerConfig) {
            ConfigValidationUtils.validateConsumerConfig((ConsumerConfig)config);
        } else if (config instanceof ApplicationConfig) {
            ConfigValidationUtils.validateApplicationConfig((ApplicationConfig)config);
        } else if (config instanceof MonitorConfig) {
            ConfigValidationUtils.validateMonitorConfig((MonitorConfig)config);
        } else if (config instanceof ModuleConfig) {
            ConfigValidationUtils.validateModuleConfig((ModuleConfig)config);
        } else if (config instanceof MetricsConfig) {
            ConfigValidationUtils.validateMetricsConfig((MetricsConfig)config);
        } else if (config instanceof SslConfig) {
            ConfigValidationUtils.validateSslConfig((SslConfig)config);
        }
    }

    private <T extends AbstractConfig> boolean isRequired(Class<T> clazz) {
        return clazz != RegistryConfig.class && clazz != MetadataReportConfig.class && clazz != MonitorConfig.class && clazz != MetricsConfig.class;
    }

    private <T extends AbstractConfig> boolean shouldAddDefaultConfig(Class<T> clazz) {
        if (!this.isRequired(clazz)) {
            return false;
        }
        return this.configManager.getDefaultConfigs(clazz).isEmpty();
    }

    private void startConfigCenter() {
        this.loadConfigs(ApplicationConfig.class);
        this.loadConfigs(ConfigCenterConfig.class);
        this.useRegistryAsConfigCenterIfNecessary();
        Collection configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty((Collection)configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.refresh();
            ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                this.environment.updateExternalConfigMap(configCenter.getExternalConfiguration());
                this.environment.updateAppExternalConfigMap(configCenter.getAppExternalConfiguration());
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration((DynamicConfiguration)compositeDynamicConfiguration);
        }
        this.configManager.refreshAll();
    }

    private void startMetadataCenter() {
        this.useRegistryAsMetadataCenterIfNecessary();
        ApplicationConfig applicationConfig = this.getApplication();
        String metadataType = applicationConfig.getMetadataType();
        Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty((Collection)metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, Metadata Center address is required when 'metadata=remote' is enabled.");
            }
            return;
        }
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            if (!metadataReportConfig.isValid()) {
                this.logger.info("Ignore invalid metadata-report config: " + metadataReportConfig);
                continue;
            }
            MetadataReportInstance.init((MetadataReportConfig)metadataReportConfig);
        }
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.configManager.getConfigCenters())) {
            return;
        }
        this.loadConfigs(RegistryConfig.class);
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (defaultRegistries.size() > 0) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsConfigCenter).map(this::registryAsConfigCenter).forEach(configCenter -> {
                if (this.configManager.getConfigCenter(configCenter.getId()).isPresent()) {
                    return;
                }
                this.configManager.addConfigCenter(configCenter);
                this.logger.info("use registry as config-center: " + configCenter);
            });
        }
    }

    private boolean isUsedRegistryAsConfigCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsConfigCenter(), "config", DynamicConfigurationFactory.class);
    }

    private ConfigCenterConfig registryAsConfigCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        URL url = URL.valueOf((String)registryConfig.getAddress());
        String id = "config-center-" + protocol + "-" + url.getHost() + "-" + port;
        ConfigCenterConfig cc = new ConfigCenterConfig();
        cc.setId(id);
        if (cc.getParameters() == null) {
            cc.setParameters(new HashMap());
        }
        if (registryConfig.getParameters() != null) {
            cc.getParameters().putAll(registryConfig.getParameters());
        }
        cc.getParameters().put("client", registryConfig.getClient());
        cc.setProtocol(protocol);
        cc.setPort(port);
        if (StringUtils.isNotEmpty((String)registryConfig.getGroup())) {
            cc.setGroup(registryConfig.getGroup());
        }
        cc.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        cc.setNamespace(registryConfig.getGroup());
        cc.setUsername(registryConfig.getUsername());
        cc.setPassword(registryConfig.getPassword());
        if (registryConfig.getTimeout() != null) {
            cc.setTimeout(Long.valueOf(registryConfig.getTimeout().longValue()));
        }
        cc.setHighestPriority(Boolean.valueOf(false));
        return cc;
    }

    private void useRegistryAsMetadataCenterIfNecessary() {
        Collection metadataConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isNotEmpty((Collection)metadataConfigs)) {
            return;
        }
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (defaultRegistries.size() > 0) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsMetadataCenter).map(this::registryAsMetadataCenter).forEach(metadataReportConfig -> {
                Optional configOptional = this.configManager.getConfig(MetadataReportConfig.class, metadataReportConfig.getId());
                if (configOptional.isPresent()) {
                    return;
                }
                this.configManager.addMetadataReport(metadataReportConfig);
                this.logger.info("use registry as metadata-center: " + metadataReportConfig);
            });
        }
    }

    private boolean isUsedRegistryAsMetadataCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsMetadataCenter(), "metadata", MetadataReportFactory.class);
    }

    private boolean isUsedRegistryAsCenter(RegistryConfig registryConfig, Supplier<Boolean> usedRegistryAsCenter, String centerType, Class<?> extensionClass) {
        boolean supported;
        Boolean configuredValue = usedRegistryAsCenter.get();
        if (configuredValue != null) {
            supported = configuredValue;
        } else {
            String protocol = registryConfig.getProtocol();
            supported = this.supportsExtension(extensionClass, protocol);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("No value is configured in the registry, the %s extension[name : %s] %s as the %s center", extensionClass.getSimpleName(), protocol, supported ? "supports" : "does not support", centerType));
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("The registry[%s] will be %s as the %s center", registryConfig, supported ? "used" : "not used", centerType));
        }
        return supported;
    }

    private boolean supportsExtension(Class<?> extensionClass, String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(extensionClass);
            return extensionLoader.hasExtension(name);
        }
        return false;
    }

    private MetadataReportConfig registryAsMetadataCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        URL url = URL.valueOf((String)registryConfig.getAddress());
        String id = "metadata-center-" + protocol + "-" + url.getHost() + "-" + url.getPort();
        MetadataReportConfig metadataReportConfig = new MetadataReportConfig();
        metadataReportConfig.setId(id);
        if (metadataReportConfig.getParameters() == null) {
            metadataReportConfig.setParameters(new HashMap());
        }
        if (registryConfig.getParameters() != null) {
            metadataReportConfig.getParameters().putAll(registryConfig.getParameters());
        }
        metadataReportConfig.getParameters().put("client", registryConfig.getClient());
        metadataReportConfig.setGroup(registryConfig.getGroup());
        metadataReportConfig.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        metadataReportConfig.setUsername(registryConfig.getUsername());
        metadataReportConfig.setPassword(registryConfig.getPassword());
        metadataReportConfig.setTimeout(registryConfig.getTimeout());
        return metadataReportConfig;
    }

    private String getRegistryCompatibleAddress(RegistryConfig registryConfig) {
        String registryAddress = registryConfig.getAddress();
        Object[] addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(registryAddress);
        if (ArrayUtils.isEmpty((Object[])addresses)) {
            throw new IllegalStateException("Invalid registry address found.");
        }
        Object address = addresses[0];
        StringBuilder metadataAddressBuilder = new StringBuilder();
        URL url = URL.valueOf((String)address);
        String protocolFromAddress = url.getProtocol();
        if (StringUtils.isEmpty((String)protocolFromAddress)) {
            String protocolFromConfig = registryConfig.getProtocol();
            metadataAddressBuilder.append(protocolFromConfig).append("://");
        }
        metadataAddressBuilder.append((String)address);
        return metadataAddressBuilder.toString();
    }

    private void loadConfigsFromProps() {
        this.loadConfigs(ApplicationConfig.class);
        this.loadConfigs(ModuleConfig.class);
        this.loadConfigs(MonitorConfig.class);
        this.loadConfigs(MetricsConfig.class);
        this.loadConfigs(ProtocolConfig.class);
        this.loadConfigs(RegistryConfig.class);
        this.loadConfigs(ProviderConfig.class);
        this.loadConfigs(ConsumerConfig.class);
        this.loadConfigs(MetadataReportConfig.class);
    }

    private <T extends AbstractConfig> void loadConfigs(Class<T> cls) {
        Environment env;
        List configurationMaps;
        Set<String> configIds = this.getConfigIds(cls);
        configIds.forEach(id -> {
            block9: {
                if (!this.configManager.getConfig(cls, id).isPresent()) {
                    AbstractConfig config = null;
                    try {
                        config = (AbstractConfig)cls.newInstance();
                        config.setId(id);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("create config instance failed, id: " + id + ", type:" + cls.getSimpleName());
                    }
                    String key = null;
                    boolean addDefaultNameConfig = false;
                    try {
                        key = "dubbo." + AbstractConfig.getPluralTagName((Class)cls) + "." + id + ".name";
                        if (ConfigUtils.getProperties().getProperty(key) == null) {
                            ConfigUtils.getProperties().setProperty(key, (String)id);
                            addDefaultNameConfig = true;
                        }
                        config.refresh();
                        this.configManager.addConfig(config);
                        if (!addDefaultNameConfig || key == null) break block9;
                        ConfigUtils.getProperties().remove(key);
                    }
                    catch (Exception e) {
                        try {
                            this.logger.error("load config failed, id: " + id + ", type:" + cls.getSimpleName(), (Throwable)e);
                            throw new IllegalStateException("load config failed, id: " + id + ", type:" + cls.getSimpleName());
                        }
                        catch (Throwable throwable) {
                            if (addDefaultNameConfig && key != null) {
                                ConfigUtils.getProperties().remove(key);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        });
        if (this.configManager.getConfigs(cls).isEmpty() && ConfigurationUtils.hasSubProperties((Collection)(configurationMaps = (env = ApplicationModel.getEnvironment()).getConfigurationMaps()), (String)AbstractConfig.getTypePrefix(cls))) {
            AbstractConfig config = null;
            try {
                config = (AbstractConfig)cls.newInstance();
                config.refresh();
            }
            catch (Exception e) {
                throw new IllegalStateException("create default config instance failed, type:" + cls.getSimpleName());
            }
            this.configManager.addConfig(config);
        }
    }

    private Set<String> getConfigIds(Class<? extends AbstractConfig> clazz) {
        String prefix = "dubbo." + AbstractConfig.getPluralTagName(clazz) + ".";
        Environment environment = ApplicationModel.getEnvironment();
        return ConfigurationUtils.getSubIds((Collection)environment.getConfigurationMaps(), (String)prefix);
    }

    private void initMetadataService() {
        this.metadataService = WritableMetadataService.getDefaultExtension();
        this.metadataServiceExporter = new ConfigurableMetadataServiceExporter(this.metadataService);
    }

    public synchronized DubboBootstrap start() {
        if (this.isCurrentlyInStart) {
            return this;
        }
        this.isCurrentlyInStart = true;
        try {
            if (this.started.compareAndSet(false, true)) {
                this.startup.set(false);
                this.shutdown.set(false);
                this.awaited.set(false);
                this.initialize();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is starting...");
                }
                this.doStart();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " has started.");
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is started, export/refer new services.");
                }
                this.doStart();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " finish export/refer new services.");
                }
            }
            DubboBootstrap dubboBootstrap = this;
            return dubboBootstrap;
        }
        finally {
            this.isCurrentlyInStart = false;
        }
    }

    private void doStart() {
        this.exportServices();
        if (this.isRegisterConsumerInstance() || this.hasExportedServices()) {
            this.exportMetadataService();
            this.registerServiceInstance();
        }
        this.referServices();
        this.awaitFinish();
        if (this.isExportBackground() || this.isReferBackground()) {
            new Thread(() -> {
                while (!this.asyncExportFinish || !this.asyncReferFinish) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error(NAME + " waiting async export / refer occurred and error.", (Throwable)e);
                    }
                }
                this.onStarted();
            }).start();
        } else {
            this.onStarted();
        }
    }

    private boolean hasExportedServices() {
        return CollectionUtils.isNotEmpty((Collection)this.configManager.getServices());
    }

    public DubboBootstrap await() {
        if (!this.awaited.get() && !this.executorService.isShutdown()) {
            this.executeMutually(() -> {
                while (!this.awaited.get()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(NAME + " awaiting ...");
                    }
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        return this;
    }

    private void waitAsyncExportIfNeeded() {
        if (this.asyncExportingFutures.size() > 0) {
            this.asyncExportFinish = false;
            if (this.isExportBackground()) {
                new Thread(this::waitExportFinish).start();
            } else {
                this.waitExportFinish();
            }
        }
    }

    private boolean isExportBackground() {
        List list = this.configManager.getProviders().stream().map(ProviderConfig::getExportBackground).filter(k -> k != null && k != false).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(list);
    }

    private void waitExportFinish() {
        try {
            this.logger.info(NAME + " waiting services exporting asynchronously...");
            CompletableFuture<Void> future = CompletableFuture.allOf(this.asyncExportingFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        catch (Exception e) {
            this.logger.warn(NAME + " asynchronous export occurred an exception.");
        }
        finally {
            this.executorRepository.shutdownServiceExportExecutor();
            this.logger.info(NAME + " asynchronous export finished.");
            this.asyncExportFinish = true;
        }
    }

    private void waitAsyncReferIfNeeded() {
        if (this.asyncReferringFutures.size() > 0) {
            this.asyncReferFinish = false;
            if (this.isReferBackground()) {
                new Thread(this::waitReferFinish).start();
            } else {
                this.waitReferFinish();
            }
        }
    }

    private boolean isReferBackground() {
        List list = this.configManager.getConsumers().stream().map(ConsumerConfig::getReferBackground).filter(k -> k != null && k != false).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(list);
    }

    private void waitReferFinish() {
        try {
            this.logger.info(NAME + " waiting services referring asynchronously...");
            CompletableFuture<Void> future = CompletableFuture.allOf(this.asyncReferringFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        catch (Exception e) {
            this.logger.warn(NAME + " asynchronous refer occurred an exception.");
        }
        finally {
            this.executorRepository.shutdownServiceExportExecutor();
            this.logger.info(NAME + " asynchronous refer finished.");
            this.asyncReferFinish = true;
        }
    }

    private void awaitFinish() {
        this.waitAsyncExportIfNeeded();
        this.waitAsyncReferIfNeeded();
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStartup() {
        return this.startup.get();
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public DubboBootstrap stop() throws IllegalStateException {
        this.destroy();
        return this;
    }

    private ApplicationBuilder createApplicationBuilder(String name) {
        return new ApplicationBuilder().name(name);
    }

    private RegistryBuilder createRegistryBuilder(String id) {
        return new RegistryBuilder().id(id);
    }

    private ProtocolBuilder createProtocolBuilder(String id) {
        return new ProtocolBuilder().id(id);
    }

    private ServiceBuilder createServiceBuilder(String id) {
        return new ServiceBuilder().id(id);
    }

    private ReferenceBuilder createReferenceBuilder(String id) {
        return new ReferenceBuilder().id(id);
    }

    private ProviderBuilder createProviderBuilder(String id) {
        return (ProviderBuilder)new ProviderBuilder().id(id);
    }

    private ConsumerBuilder createConsumerBuilder(String id) {
        return (ConsumerBuilder)new ConsumerBuilder().id(id);
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            if (!configCenter.checkOrUpdateInited()) {
                return null;
            }
            DynamicConfiguration dynamicConfiguration = this.getDynamicConfiguration(configCenter.toUrl());
            String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
            String appGroup = this.getApplication().getName();
            String appConfigContent = null;
            if (StringUtils.isNotEmpty((String)appGroup)) {
                appConfigContent = dynamicConfiguration.getProperties(StringUtils.isNotEmpty((String)configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup);
            }
            try {
                this.environment.updateExternalConfigMap(ConfigurationUtils.parseProperties((String)configContent));
                this.environment.updateAppExternalConfigMap(ConfigurationUtils.parseProperties((String)appConfigContent));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
            }
            return dynamicConfiguration;
        }
        return null;
    }

    private DynamicConfiguration getDynamicConfiguration(URL connectionURL) {
        String protocol = connectionURL.getProtocol();
        DynamicConfigurationFactory factory = DynamicConfigurationFactory.getDynamicConfigurationFactory((String)protocol);
        return factory.getDynamicConfiguration(connectionURL);
    }

    private void exportMetadataService() {
        this.metadataServiceExporter.export();
    }

    private void unexportMetadataService() {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            this.metadataServiceExporter.unexport();
        }
    }

    private void exportServices() {
        for (ServiceConfigBase sc : this.configManager.getServices()) {
            ServiceConfig serviceConfig = (ServiceConfig)sc;
            serviceConfig.setBootstrap(this);
            if (!serviceConfig.isRefreshed()) {
                serviceConfig.refresh();
            }
            if (sc.isExported()) continue;
            if (sc.shouldExportAsync().booleanValue()) {
                ExecutorService executor = this.executorRepository.getServiceExportExecutor();
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    try {
                        if (!sc.isExported()) {
                            sc.export();
                            this.exportedServices.add(sc);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.error("export async catch error : " + t.getMessage(), t);
                    }
                }, executor);
                this.asyncExportingFutures.add(future);
                continue;
            }
            if (sc.isExported()) continue;
            sc.export();
            this.exportedServices.add(sc);
        }
    }

    private void unexportServices() {
        this.exportedServices.forEach(sc -> {
            this.configManager.removeConfig((AbstractConfig)sc);
            sc.unexport();
        });
        this.asyncExportingFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncExportingFutures.clear();
        this.exportedServices.clear();
    }

    private void referServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.configManager.getReferences().forEach(rc -> {
            ReferenceConfig referenceConfig = (ReferenceConfig)((Object)rc);
            referenceConfig.setBootstrap(this);
            if (!referenceConfig.isRefreshed()) {
                referenceConfig.refresh();
            }
            if (rc.shouldInit()) {
                if (rc.shouldReferAsync().booleanValue()) {
                    ExecutorService executor = this.executorRepository.getServiceReferExecutor();
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        try {
                            this.cache.get(rc);
                        }
                        catch (Throwable t) {
                            this.logger.error("refer async catch error : " + t.getMessage(), t);
                        }
                    }, executor);
                    this.asyncReferringFutures.add(future);
                } else {
                    this.cache.get(rc);
                }
            }
        });
    }

    private void unreferServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.asyncReferringFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncReferringFutures.clear();
        this.cache.destroyAll();
    }

    private void registerServiceInstance() {
        if (this.serviceInstance != null) {
            return;
        }
        ApplicationConfig application = this.getApplication();
        String serviceName = application.getName();
        ServiceInstance serviceInstance = this.createServiceInstance(serviceName);
        try {
            this.doRegisterServiceInstance(serviceInstance);
        }
        catch (Exception e) {
            this.logger.error("Register instance error", (Throwable)e);
        }
        this.executorRepository.nextScheduledExecutor().scheduleAtFixedRate(() -> {
            InMemoryWritableMetadataService localMetadataService = (InMemoryWritableMetadataService)WritableMetadataService.getDefaultExtension();
            localMetadataService.blockUntilUpdated();
            try {
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ServiceInstance)serviceInstance);
            }
            catch (Exception e) {
                this.logger.error("Refresh instance and metadata error", (Throwable)e);
            }
            finally {
                localMetadataService.releaseBlock();
            }
        }, 0L, ConfigurationUtils.get((String)"dubbo.application.metadata.delay", (int)10000), TimeUnit.MILLISECONDS);
    }

    private void doRegisterServiceInstance(ServiceInstance serviceInstance) {
        if (serviceInstance.getPort() > 0) {
            this.publishMetadataToRemote(serviceInstance);
            this.logger.info("Start registering instance address to registry.");
            AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> {
                DefaultServiceInstance serviceInstanceForRegistry = new DefaultServiceInstance((DefaultServiceInstance)serviceInstance);
                ServiceInstanceMetadataUtils.calInstanceRevision((ServiceDiscovery)serviceDiscovery, (ServiceInstance)serviceInstanceForRegistry);
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Start registering instance address to registry" + serviceDiscovery.getUrl() + ", instance " + serviceInstanceForRegistry);
                }
                serviceDiscovery.register((ServiceInstance)serviceInstanceForRegistry);
            });
        }
    }

    private void publishMetadataToRemote(ServiceInstance serviceInstance) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Start publishing metadata to remote center, this only makes sense for applications enabled remote metadata center.");
        }
        RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
        remoteMetadataService.publishMetadata(serviceInstance.getServiceName());
    }

    private void unregisterServiceInstance() {
        if (this.serviceInstance != null) {
            AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> serviceDiscovery.unregister(this.serviceInstance));
        }
    }

    private ServiceInstance createServiceInstance(String serviceName) {
        this.serviceInstance = new DefaultServiceInstance(serviceName);
        ServiceInstanceMetadataUtils.setMetadataStorageType((ServiceInstance)this.serviceInstance, (String)this.getMetadataType());
        ServiceInstanceMetadataUtils.customizeInstance((ServiceInstance)this.serviceInstance);
        return this.serviceInstance;
    }

    public void destroy() {
        if (this.destroyLock.tryLock() && this.shutdown.compareAndSet(false, true)) {
            try {
                if (this.destroyed.compareAndSet(false, true)) {
                    if (this.started.compareAndSet(true, false)) {
                        this.unregisterServiceInstance();
                        this.unexportMetadataService();
                        this.unexportServices();
                        this.unreferServices();
                    }
                    this.destroyRegistries();
                    this.destroyProtocols();
                    this.destroyServiceDiscoveries();
                    this.destroyExecutorRepository();
                    this.destroyMetadataReports();
                    this.checkConfigState();
                    this.clear();
                    this.shutdown();
                    this.release();
                    this.onStop();
                }
                this.destroyDynamicConfigurations();
                ShutdownHookCallbacks.INSTANCE.clear();
            }
            finally {
                this.initialized.set(false);
                this.startup.set(false);
                this.destroyLock.unlock();
            }
        }
    }

    private void onStarted() {
        this.startup.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(NAME + " is ready.");
        }
        ExtensionLoader exts = ExtensionLoader.getExtensionLoader(DubboBootstrapStartStopListener.class);
        exts.getSupportedExtensionInstances().forEach(ext -> ext.onStart(this));
    }

    private void onStop() {
        ExtensionLoader exts = ExtensionLoader.getExtensionLoader(DubboBootstrapStartStopListener.class);
        exts.getSupportedExtensionInstances().forEach(ext -> ext.onStop(this));
    }

    private void checkConfigState() {
        if (!ignoreConfigState && !this.configManager.getApplication().isPresent()) {
            this.logger.error("Dubbo config was cleaned prematurely");
            throw new IllegalStateException("Dubbo config was cleaned prematurely");
        }
    }

    private void destroyExecutorRepository() {
        ((ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).destroyAll();
    }

    private void destroyRegistries() {
        AbstractRegistryFactory.destroyAll();
    }

    private void destroyProtocols() {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Protocol.class);
        for (String protocolName : loader.getLoadedExtensions()) {
            try {
                Protocol protocol = (Protocol)loader.getLoadedExtension(protocolName);
                if (protocol == null) continue;
                protocol.destroy();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    private void destroyServiceDiscoveries() {
        AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> ThrowableAction.execute(() -> ((ServiceDiscovery)serviceDiscovery).destroy()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void destroyMetadataReports() {
        AbstractMetadataReportFactory.destroy();
        MetadataReportInstance.reset();
        ExtensionLoader.resetExtensionLoader(MetadataReportFactory.class);
    }

    private void destroyDynamicConfigurations() {
        ExtensionLoader.resetExtensionLoader(DynamicConfigurationFactory.class);
    }

    private void clear() {
        this.clearConfigs();
        this.clearApplicationModel();
    }

    private void clearApplicationModel() {
    }

    private void clearConfigs() {
        this.configManager.destroy();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s configs have been clear.");
        }
    }

    private void release() {
        this.executeMutually(() -> {
            if (this.awaited.compareAndSet(false, true)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is about to shutdown...");
                }
                this.condition.signalAll();
            }
        });
    }

    private void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ApplicationConfig getApplication() {
        return this.configManager.getApplicationOrElseThrow();
    }

    public void setTakeoverMode(BootstrapTakeoverMode takeoverMode) {
        this.started.set(false);
        this.takeoverMode = takeoverMode;
    }

    public BootstrapTakeoverMode getTakeoverMode() {
        return this.takeoverMode;
    }
}

