/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.json.JsonUtil;
import org.apache.dubbo.common.utils.CollectionUtils;

public abstract class AbstractJsonUtilImpl
implements JsonUtil {
    @Override
    public boolean isSupport() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("json", "test");
            if (!CollectionUtils.mapEquals(map, (Map)this.toJavaObject(this.toJson(map), (Type)((Object)Map.class)))) {
                return false;
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add("json");
            return CollectionUtils.equals(list, this.toJavaList(this.toJson(list), String.class));
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public List<?> getList(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not List", value, key, obj));
        }
        return (List)value;
    }

    @Override
    public List<Map<String, ?>> getListOfObjects(Map<String, ?> obj, String key) {
        assert (obj != null);
        List<?> list = this.getList(obj, key);
        if (list == null) {
            return null;
        }
        return this.checkObjectList(list);
    }

    @Override
    public List<String> getListOfStrings(Map<String, ?> obj, String key) {
        assert (obj != null);
        List<?> list = this.getList(obj, key);
        if (list == null) {
            return null;
        }
        return this.checkStringList(list);
    }

    @Override
    public Map<String, ?> getObject(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Map)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not object", value, key, obj));
        }
        return (Map)value;
    }

    @Override
    public Double getNumberAsDouble(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a double", value, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' in '%s' is not a number", value, key, obj));
    }

    @Override
    public Integer getNumberAsInteger(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (value instanceof Double) {
            Double d = (Double)value;
            int i = d.intValue();
            if ((double)i != d) {
                throw new ClassCastException("Number expected to be integer: " + d);
            }
            return i;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not an integer", value, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not an integer", value, key));
    }

    @Override
    public Long getNumberAsLong(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (value instanceof Double) {
            Double d = (Double)value;
            long l = d.longValue();
            if ((double)l != d) {
                throw new ClassCastException("Number expected to be long: " + d);
            }
            return l;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a long integer", value, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a long integer", value, key));
    }

    @Override
    public String getString(Map<String, ?> obj, String key) {
        assert (obj != null);
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof String)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not String", value, key, obj));
        }
        return (String)value;
    }

    @Override
    public List<Map<String, ?>> checkObjectList(List<?> rawList) {
        assert (rawList != null);
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    @Override
    public List<String> checkStringList(List<?> rawList) {
        assert (rawList != null);
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof String) continue;
            throw new ClassCastException(String.format("value '%s' for idx %d in '%s' is not string", rawList.get(i), i, rawList));
        }
        return rawList;
    }
}

