/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.model.MethodDescriptor;

public class ReflectionMethodDescriptor
implements MethodDescriptor {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReflectionMethodDescriptor.class);
    private final ConcurrentMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    public final String methodName;
    private final String[] compatibleParamSignatures;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final Type[] returnTypes;
    private final String paramDesc;
    private final Method method;
    private final boolean generic;
    private final MethodDescriptor.RpcType rpcType;
    private Class<?>[] actualRequestTypes;
    private Class<?> actualResponseType;

    public ReflectionMethodDescriptor(Method method) {
        Type[] returnTypesResult;
        this.method = method;
        this.methodName = method.getName();
        this.parameterClasses = method.getParameterTypes();
        this.returnClass = method.getReturnType();
        try {
            returnTypesResult = ReflectUtils.getReturnTypes(method);
        }
        catch (Throwable throwable) {
            logger.error("0-8", "", "", "fail to get return types. Method name: " + this.methodName + " Declaring class:" + method.getDeclaringClass().getName(), throwable);
            returnTypesResult = new Type[]{this.returnClass, this.returnClass};
        }
        this.returnTypes = returnTypesResult;
        this.paramDesc = ReflectUtils.getDesc(this.parameterClasses);
        this.compatibleParamSignatures = (String[])Stream.of(this.parameterClasses).map(Class::getName).toArray(String[]::new);
        this.generic = (this.methodName.equals("$invoke") || this.methodName.equals("$invokeAsync")) && this.parameterClasses.length == 3;
        this.rpcType = this.determineRpcType();
    }

    private MethodDescriptor.RpcType determineRpcType() {
        if (this.generic) {
            return MethodDescriptor.RpcType.UNARY;
        }
        if (this.parameterClasses.length > 2) {
            return MethodDescriptor.RpcType.UNARY;
        }
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        if (this.parameterClasses.length == 1 && this.isStreamType(this.parameterClasses[0]) && this.isStreamType(this.returnClass)) {
            this.actualRequestTypes = new Class[]{this.obtainActualTypeInStreamObserver(((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0])};
            this.actualResponseType = this.obtainActualTypeInStreamObserver(((ParameterizedType)genericParameterTypes[0]).getActualTypeArguments()[0]);
            return MethodDescriptor.RpcType.BI_STREAM;
        }
        boolean returnIsVoid = this.returnClass.getName().equals(Void.TYPE.getName());
        if (returnIsVoid && this.parameterClasses.length == 1 && this.isStreamType(this.parameterClasses[0])) {
            this.actualRequestTypes = Collections.emptyList().toArray(new Class[0]);
            this.actualResponseType = this.obtainActualTypeInStreamObserver(((ParameterizedType)this.method.getGenericParameterTypes()[0]).getActualTypeArguments()[0]);
            return MethodDescriptor.RpcType.SERVER_STREAM;
        }
        if (returnIsVoid && this.parameterClasses.length == 2 && !this.isStreamType(this.parameterClasses[0]) && this.isStreamType(this.parameterClasses[1])) {
            this.actualRequestTypes = this.parameterClasses;
            this.actualResponseType = this.obtainActualTypeInStreamObserver(((ParameterizedType)this.method.getGenericParameterTypes()[1]).getActualTypeArguments()[0]);
            return MethodDescriptor.RpcType.SERVER_STREAM;
        }
        if (Arrays.stream(this.parameterClasses).anyMatch(this::isStreamType) || this.isStreamType(this.returnClass)) {
            throw new IllegalStateException("Bad stream method signature. method(" + this.methodName + ":" + this.paramDesc + ")");
        }
        return MethodDescriptor.RpcType.UNARY;
    }

    private boolean isStreamType(Class<?> classType) {
        return StreamObserver.class.isAssignableFrom(classType);
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    @Override
    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    @Override
    public String getParamDesc() {
        return this.paramDesc;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    @Override
    public MethodDescriptor.RpcType getRpcType() {
        return this.rpcType;
    }

    @Override
    public boolean isGeneric() {
        return this.generic;
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    @Override
    public Class<?>[] getActualRequestTypes() {
        return this.actualRequestTypes;
    }

    @Override
    public Class<?> getActualResponseType() {
        return this.actualResponseType;
    }

    private Class<?> obtainActualTypeInStreamObserver(Type typeInStreamObserver) {
        return (Class)(typeInStreamObserver instanceof ParameterizedType ? ((ParameterizedType)typeInStreamObserver).getRawType() : typeInStreamObserver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectionMethodDescriptor that = (ReflectionMethodDescriptor)o;
        return this.generic == that.generic && Objects.equals(this.method, that.method) && Objects.equals(this.paramDesc, that.paramDesc) && Arrays.equals(this.compatibleParamSignatures, that.compatibleParamSignatures) && Arrays.equals(this.parameterClasses, that.parameterClasses) && Objects.equals(this.returnClass, that.returnClass) && Arrays.equals(this.returnTypes, that.returnTypes) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.attributeMap, that.attributeMap);
    }

    public int hashCode() {
        int result = Objects.hash(this.method, this.paramDesc, this.returnClass, this.methodName, this.generic, this.attributeMap);
        result = 31 * result + Arrays.hashCode(this.compatibleParamSignatures);
        result = 31 * result + Arrays.hashCode(this.parameterClasses);
        result = 31 * result + Arrays.hashCode(this.returnTypes);
        return result;
    }

    public String toString() {
        return "ReflectionMethodDescriptor{method='" + MethodUtils.toShortString(this.method) + "', rpcType=" + (Object)((Object)this.rpcType) + '}';
    }
}

