/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.OrderedPropertiesProvider;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.ModuleModel;

public class OrderedPropertiesConfiguration
implements Configuration {
    private Properties properties;
    private ModuleModel moduleModel;

    public OrderedPropertiesConfiguration(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        this.refresh();
    }

    public void refresh() {
        this.properties = new Properties();
        ExtensionLoader<OrderedPropertiesProvider> propertiesProviderExtensionLoader = this.moduleModel.getExtensionLoader(OrderedPropertiesProvider.class);
        Set<String> propertiesProviderNames = propertiesProviderExtensionLoader.getSupportedExtensions();
        if (CollectionUtils.isEmpty(propertiesProviderNames)) {
            return;
        }
        ArrayList<OrderedPropertiesProvider> orderedPropertiesProviders = new ArrayList<OrderedPropertiesProvider>();
        for (String propertiesProviderName : propertiesProviderNames) {
            orderedPropertiesProviders.add(propertiesProviderExtensionLoader.getExtension(propertiesProviderName));
        }
        orderedPropertiesProviders.sort((a, b) -> b.priority() - a.priority());
        for (OrderedPropertiesProvider orderedPropertiesProvider : orderedPropertiesProviders) {
            this.properties.putAll((Map<?, ?>)orderedPropertiesProvider.initProperties());
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String remove(String key) {
        return (String)this.properties.remove(key);
    }

    @Deprecated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

