/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;
import org.apache.dubbo.metadata.definition.util.ClassUtils;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        int actualTypeArgsLength;
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getCanonicalName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        int n = actualTypeArgsLength = actualTypeArgs == null ? 0 : actualTypeArgs.length;
        if (actualTypeArgsLength != 2) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Map type [{0}] with unexpected amount of arguments [{1}]." + Arrays.toString(actualTypeArgs), type, actualTypeArgs));
        }
        String mapType = ClassUtils.getCanonicalNameForParameterizedType(parameterizedType);
        TypeDefinition td = typeCache.get(mapType);
        if (td != null) {
            return td;
        }
        td = new TypeDefinition(mapType);
        typeCache.put(mapType, td);
        for (int i = 0; i < actualTypeArgsLength; ++i) {
            Object actualType = actualTypeArgs[i];
            TypeDefinition item = null;
            Class<?> rawType = TypeUtils.getRawClass((Type)actualType);
            if (TypeUtils.isParameterizedType((Type)actualType)) {
                item = TypeDefinitionBuilder.build((Type)actualType, rawType, typeCache);
            } else if (TypeUtils.isClass((Type)actualType)) {
                item = TypeDefinitionBuilder.build(null, rawType, typeCache);
            }
            if (item == null) continue;
            td.getItems().add(item.getType());
        }
        return td;
    }
}

