/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.config.ModuleEnvironment;
import org.apache.dubbo.common.context.ModuleExt;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;

public class ModuleModel
extends ScopeModel {
    private static final Logger logger = LoggerFactory.getLogger(ModuleModel.class);
    private static final AtomicLong index = new AtomicLong(0L);
    public static final String NAME = "ModuleModel";
    private final ApplicationModel applicationModel;
    private ModuleEnvironment moduleEnvironment;
    private ModuleServiceRepository serviceRepository;
    private ModuleConfigManager moduleConfigManager;
    private ModuleDeployer deployer;

    public ModuleModel(ApplicationModel applicationModel) {
        this(applicationModel, false);
    }

    public ModuleModel(ApplicationModel applicationModel, boolean isInternal) {
        super(applicationModel, ExtensionScope.MODULE);
        Assert.notNull((Object)applicationModel, "ApplicationModel can not be null");
        this.applicationModel = applicationModel;
        applicationModel.addModule(this, isInternal);
        this.initialize();
        Assert.notNull((Object)applicationModel, "ApplicationModel can not be null");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.serviceRepository = new ModuleServiceRepository(this);
        this.moduleConfigManager = new ModuleConfigManager(this);
        this.moduleConfigManager.initialize();
        this.initModuleExt();
        ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
        Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
        for (ScopeModelInitializer initializer : initializers) {
            initializer.initializeModuleModel(this);
        }
    }

    private void initModuleExt() {
        Set<ModuleExt> exts = this.getExtensionLoader(ModuleExt.class).getSupportedExtensionInstances();
        for (ModuleExt ext : exts) {
            ext.initialize();
        }
    }

    @Override
    protected void onDestroy() {
        if (this.deployer != null) {
            this.deployer.preDestroy();
        }
        this.applicationModel.removeModule(this);
        if (this.deployer != null) {
            this.deployer.postDestroy();
        }
        this.notifyDestroy();
        if (this.serviceRepository != null) {
            this.serviceRepository.destroy();
            this.serviceRepository = null;
        }
        if (this.moduleEnvironment != null) {
            this.moduleEnvironment.destroy();
            this.moduleEnvironment = null;
        }
        this.applicationModel.tryDestroy();
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public ModuleServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        super.addClassLoader(classLoader);
        if (this.moduleEnvironment != null) {
            this.moduleEnvironment.refreshClassLoaders();
        }
    }

    @Override
    public ModuleEnvironment getModelEnvironment() {
        if (this.moduleEnvironment == null) {
            this.moduleEnvironment = (ModuleEnvironment)this.getExtensionLoader(ModuleExt.class).getExtension("moduleEnvironment");
        }
        return this.moduleEnvironment;
    }

    public ModuleConfigManager getConfigManager() {
        return this.moduleConfigManager;
    }

    public ModuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ModuleDeployer deployer) {
        this.deployer = deployer;
    }

    @Deprecated
    public void setModuleEnvironment(ModuleEnvironment moduleEnvironment) {
        this.moduleEnvironment = moduleEnvironment;
    }

    @Deprecated
    public void setServiceRepository(ModuleServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    @Deprecated
    public void setModuleConfigManager(ModuleConfigManager moduleConfigManager) {
        this.moduleConfigManager = moduleConfigManager;
    }
}

