/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.utils.ReflectUtils;

public class MethodDescriptor {
    private final Method method;
    private final String paramDesc;
    private final String[] compatibleParamSignatures;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final Type[] returnTypes;
    private final String methodName;
    private final boolean generic;
    private final RpcType rpcType;
    private final ConcurrentMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    private static final Logger logger = LoggerFactory.getLogger(MethodDescriptor.class);

    public MethodDescriptor(Method method) {
        Type[] returnTypesResult;
        this.method = method;
        this.methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1 && MethodDescriptor.isStreamType(parameterTypes[0])) {
            this.parameterClasses = new Class[]{(Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]};
            this.returnClass = (Class)((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
            this.rpcType = this.needWrap() ? RpcType.STREAM_WRAP : RpcType.STREAM_UNWRAP;
        } else {
            this.parameterClasses = method.getParameterTypes();
            this.returnClass = method.getReturnType();
            this.rpcType = this.needWrap() ? RpcType.UNARY_WRAP : RpcType.UNARY_UNWRAP;
        }
        try {
            returnTypesResult = ReflectUtils.getReturnTypes(method);
        }
        catch (Throwable throwable) {
            logger.error("fail to get return types", throwable);
            returnTypesResult = new Type[]{this.returnClass, this.returnClass};
        }
        this.returnTypes = returnTypesResult;
        this.paramDesc = ReflectUtils.getDesc(this.parameterClasses);
        this.compatibleParamSignatures = (String[])Stream.of(this.parameterClasses).map(Class::getName).toArray(String[]::new);
        this.generic = (this.methodName.equals("$invoke") || this.methodName.equals("$invokeAsync")) && this.parameterClasses.length == 3;
    }

    private static boolean isStreamType(Class<?> clz) {
        return StreamObserver.class.isAssignableFrom(clz);
    }

    public boolean isStream() {
        return this.rpcType.equals((Object)RpcType.STREAM_WRAP) || this.rpcType.equals((Object)RpcType.STREAM_UNWRAP);
    }

    public boolean isUnary() {
        return this.rpcType.equals((Object)RpcType.UNARY_WRAP) || this.rpcType.equals((Object)RpcType.UNARY_UNWRAP);
    }

    public boolean isNeedWrap() {
        return this.rpcType.equals((Object)RpcType.UNARY_WRAP) || this.rpcType.equals((Object)RpcType.STREAM_WRAP);
    }

    private boolean needWrap() {
        if ("$invoke".equals(this.methodName) || "$invokeAsync".equals(this.methodName)) {
            return true;
        }
        if ("$echo".equals(this.methodName)) {
            return true;
        }
        if (this.parameterClasses.length != 1 || this.parameterClasses[0] == null) {
            return true;
        }
        for (Class<?> clazz = this.parameterClasses[0]; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            for (Class<?> clazzInterface : interfaces) {
                if (!"com.google.protobuf.Message".equalsIgnoreCase(clazzInterface.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matchParams(String params) {
        return this.paramDesc.equalsIgnoreCase(params);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getParamDesc() {
        return this.paramDesc;
    }

    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public void addAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public static enum RpcType {
        UNARY_WRAP,
        UNARY_UNWRAP,
        STREAM_WRAP,
        STREAM_UNWRAP;

    }
}

