/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import org.apache.dubbo.common.url.component.PathURLAddress;
import org.apache.dubbo.common.url.component.URLItemCache;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class URLAddress
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    protected String host;
    protected int port;
    protected transient String rawAddress;
    protected transient long timestamp;

    public URLAddress(String host, int port) {
        this(host, port, null);
    }

    public URLAddress(String host, int port, String rawAddress) {
        this.host = host;
        this.port = port = Math.max(port, 0);
        this.rawAddress = rawAddress;
        this.timestamp = System.currentTimeMillis();
    }

    public String getProtocol() {
        return "";
    }

    public URLAddress setProtocol(String protocol) {
        return this;
    }

    public String getUsername() {
        return "";
    }

    public URLAddress setUsername(String username) {
        return this;
    }

    public String getPassword() {
        return "";
    }

    public URLAddress setPassword(String password) {
        return this;
    }

    public String getPath() {
        return "";
    }

    public URLAddress setPath(String path) {
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public URLAddress setHost(String host) {
        return new URLAddress(host, this.port, this.rawAddress);
    }

    public int getPort() {
        return this.port;
    }

    public URLAddress setPort(int port) {
        return new URLAddress(this.host, port, this.rawAddress);
    }

    public String getAddress() {
        if (this.rawAddress == null) {
            this.rawAddress = this.getAddress(this.getHost(), this.getPort());
        }
        return this.rawAddress;
    }

    public URLAddress setAddress(String host, int port) {
        return new URLAddress(host, port, this.rawAddress);
    }

    public String getIp() {
        return NetUtils.getIpByHost(this.getHost());
    }

    public String getRawAddress() {
        return this.rawAddress;
    }

    protected String getAddress(String host, int port) {
        return port <= 0 ? host : host + ':' + port;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URLAddress)) {
            return false;
        }
        URLAddress that = (URLAddress)obj;
        return Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort());
    }

    public String toString() {
        if (this.rawAddress != null) {
            return this.rawAddress;
        }
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.host)) {
            buf.append(this.host);
            if (this.port > 0) {
                buf.append(':');
                buf.append(this.port);
            }
        }
        return buf.toString();
    }

    public static URLAddress parse(String rawAddress, String defaultProtocol, boolean encoded) {
        try {
            boolean isPathAddress;
            String decodeStr = rawAddress;
            if (encoded) {
                decodeStr = URLDecoder.decode(rawAddress, "UTF-8");
            }
            if (isPathAddress = decodeStr.contains("/")) {
                return URLAddress.createPathURLAddress(decodeStr, rawAddress, defaultProtocol);
            }
            return URLAddress.createURLAddress(decodeStr, rawAddress, defaultProtocol);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static URLAddress createURLAddress(String decodeStr, String rawAddress, String defaultProtocol) {
        String host = null;
        int port = 0;
        int i = decodeStr.lastIndexOf(58);
        if (i >= 0 && i < decodeStr.length() - 1) {
            if (decodeStr.lastIndexOf(37) <= i) {
                port = Integer.parseInt(decodeStr.substring(i + 1));
                host = decodeStr.substring(0, i);
            }
        } else {
            host = decodeStr;
        }
        return new URLAddress(host, port, rawAddress);
    }

    private static PathURLAddress createPathURLAddress(String decodeStr, String rawAddress, String defaultProtocol) {
        String protocol = defaultProtocol;
        String path = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        int i = decodeStr.indexOf("://");
        if (i >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + decodeStr + "\"");
            }
            protocol = decodeStr.substring(0, i);
            decodeStr = decodeStr.substring(i + 3);
        } else {
            i = decodeStr.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + decodeStr + "\"");
                }
                protocol = decodeStr.substring(0, i);
                decodeStr = decodeStr.substring(i + 1);
            }
        }
        i = decodeStr.indexOf(47);
        if (i >= 0) {
            path = decodeStr.substring(i + 1);
            decodeStr = decodeStr.substring(0, i);
        }
        if ((i = decodeStr.lastIndexOf(64)) >= 0) {
            username = decodeStr.substring(0, i);
            int j = username.indexOf(58);
            if (j >= 0) {
                password = username.substring(j + 1);
                username = username.substring(0, j);
            }
            decodeStr = decodeStr.substring(i + 1);
        }
        if ((i = decodeStr.lastIndexOf(58)) >= 0 && i < decodeStr.length() - 1 && decodeStr.lastIndexOf(37) <= i) {
            port = Integer.parseInt(decodeStr.substring(i + 1));
            host = decodeStr.substring(0, i);
        }
        protocol = URLItemCache.intern(protocol);
        path = URLItemCache.checkPath(path);
        return new PathURLAddress(protocol, username, password, path, host, port, rawAddress);
    }
}

