/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.Ring;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultExecutorRepository
implements ExecutorRepository {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutorRepository.class);
    private int DEFAULT_SCHEDULER_SIZE = Runtime.getRuntime().availableProcessors();
    private final ExecutorService SHARED_EXECUTOR = Executors.newCachedThreadPool(new NamedThreadFactory("DubboSharedHandler", true));
    private Ring<ScheduledExecutorService> scheduledExecutors = new Ring();
    private volatile ExecutorService serviceExportExecutor;
    private volatile ExecutorService serviceReferExecutor;
    private ScheduledExecutorService reconnectScheduledExecutor;
    public Ring<ScheduledExecutorService> registryNotificationExecutorRing = new Ring();
    private Ring<ScheduledExecutorService> serviceDiscoveryAddressNotificationExecutorRing = new Ring();
    private ScheduledExecutorService metadataRetryExecutor;
    private ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>> data = new ConcurrentHashMap<String, ConcurrentMap<Integer, ExecutorService>>();
    private ExecutorService poolRouterExecutor;
    private static Ring<ExecutorService> executorServiceRing = new Ring();
    private static final Object LOCK = new Object();

    public DefaultExecutorRepository() {
        int i;
        for (i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-scheduler"));
            this.scheduledExecutors.addItem(scheduler);
            executorServiceRing.addItem(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-loop", true), new ThreadPoolExecutor.AbortPolicy()));
        }
        this.poolRouterExecutor = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-pool-router", true), new ThreadPoolExecutor.AbortPolicy());
        for (i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService serviceDiscoveryAddressNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-SD-address-refresh-" + i));
            ScheduledExecutorService registryNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-registry-notification-" + i));
            this.serviceDiscoveryAddressNotificationExecutorRing.addItem(serviceDiscoveryAddressNotificationExecutor);
            this.registryNotificationExecutorRing.addItem(registryNotificationExecutor);
        }
        this.metadataRetryExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-metadata-retry"));
    }

    @Override
    public synchronized ExecutorService createExecutorIfAbsent(URL url) {
        Integer portKey;
        Map executors = this.data.computeIfAbsent(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY, k -> new ConcurrentHashMap());
        ExecutorService executor = executors.computeIfAbsent(portKey = Integer.valueOf("consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort()), k -> this.createExecutor(url));
        if (executor.isShutdown() || executor.isTerminated()) {
            executors.remove(portKey);
            executor = this.createExecutor(url);
            executors.put(portKey, executor);
        }
        return executor;
    }

    @Override
    public ExecutorService getExecutor(URL url) {
        Map executors = (Map)this.data.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
        if (executors == null) {
            logger.warn("No available executors, this is not expected, framework should call createExecutorIfAbsent first before coming to here.");
            return null;
        }
        Integer portKey = "consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort();
        ExecutorService executor = (ExecutorService)executors.get(portKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(portKey);
            executor = null;
            logger.info("Executor for " + url + " is shutdown.");
        }
        if (executor == null) {
            return this.SHARED_EXECUTOR;
        }
        return executor;
    }

    @Override
    public void updateThreadpool(URL url, ExecutorService executor) {
        try {
            if (url.hasParameter("threads") && executor instanceof ThreadPoolExecutor && !executor.isShutdown()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                int threads = url.getParameter("threads", 0);
                int max = threadPoolExecutor.getMaximumPoolSize();
                int core = threadPoolExecutor.getCorePoolSize();
                if (threads > 0 && (threads != max || threads != core)) {
                    if (threads < core) {
                        threadPoolExecutor.setCorePoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setMaximumPoolSize(threads);
                        }
                    } else {
                        threadPoolExecutor.setMaximumPoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setCorePoolSize(threads);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ScheduledExecutorService nextScheduledExecutor() {
        return this.scheduledExecutors.pollItem();
    }

    @Override
    public ExecutorService nextExecutorExecutor() {
        return executorServiceRing.pollItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getServiceExportExecutor() {
        if (this.serviceExportExecutor == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.serviceExportExecutor == null) {
                    int coreSize = this.getExportThreadNum();
                    this.serviceExportExecutor = Executors.newFixedThreadPool(coreSize, new NamedThreadFactory("Dubbo-service-export", true));
                }
            }
        }
        return this.serviceExportExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceExportExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (this.serviceExportExecutor != null && !this.serviceExportExecutor.isShutdown()) {
                this.serviceExportExecutor.shutdown();
            }
            this.serviceExportExecutor = null;
        }
    }

    private Integer getExportThreadNum() {
        List threadNum = ApplicationModel.getConfigManager().getProviders().stream().map(ProviderConfig::getExportThreadNum).filter(k -> k != null && k > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(threadNum)) {
            logger.info("Cannot get config `export-thread-num` for service export thread, using default: 10");
            return 10;
        }
        if (threadNum.size() > 1) {
            logger.info("Detect multiple config `export-thread-num` for service export thread, using: " + threadNum.get(0));
        }
        return (Integer)threadNum.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getServiceReferExecutor() {
        if (this.serviceReferExecutor == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.serviceReferExecutor == null) {
                    int coreSize = this.getReferThreadNum();
                    this.serviceReferExecutor = Executors.newFixedThreadPool(coreSize, new NamedThreadFactory("Dubbo-service-refer", true));
                }
            }
        }
        return this.serviceReferExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceReferExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (this.serviceReferExecutor != null && !this.serviceReferExecutor.isShutdown()) {
                this.serviceReferExecutor.shutdown();
            }
            this.serviceReferExecutor = null;
        }
    }

    private Integer getReferThreadNum() {
        List threadNum = ApplicationModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getReferThreadNum).filter(k -> k != null && k > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(threadNum)) {
            logger.info("Cannot get config `refer-thread-num` for service refer thread, using default: 10");
            return 10;
        }
        if (threadNum.size() > 1) {
            logger.info("Detect multiple config `refer-thread-num` for service refer thread, using: " + threadNum.get(0));
        }
        return (Integer)threadNum.get(0);
    }

    @Override
    public ScheduledExecutorService getRegistryNotificationExecutor() {
        return this.registryNotificationExecutorRing.pollItem();
    }

    @Override
    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor() {
        return this.serviceDiscoveryAddressNotificationExecutorRing.pollItem();
    }

    @Override
    public ScheduledExecutorService getMetadataRetryExecutor() {
        return this.metadataRetryExecutor;
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.SHARED_EXECUTOR;
    }

    private ExecutorService createExecutor(URL url) {
        return (ExecutorService)ExtensionLoader.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }

    @Override
    public ExecutorService getPoolRouterExecutor() {
        return this.poolRouterExecutor;
    }

    @Override
    public void destroyAll() {
        this.poolRouterExecutor.shutdown();
        this.metadataRetryExecutor.shutdown();
        this.shutdownServiceExportExecutor();
        this.shutdownServiceReferExecutor();
        this.data.values().forEach(executors -> {
            if (executors != null) {
                executors.values().forEach(executor -> {
                    if (executor != null && !executor.isShutdown()) {
                        ExecutorUtil.shutdownNow(executor, 100);
                    }
                });
            }
        });
    }
}

