/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.status.reporter;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

@SPI
public interface FrameworkStatusReporter {
    public static final Gson gson = new Gson();
    public static final Logger logger = LoggerFactory.getLogger(FrameworkStatusReporter.class);
    public static final String REGISTRATION_STATUS = "registration";
    public static final String ADDRESS_CONSUMPTION_STATUS = "consumption";
    public static final String MIGRATION_STEP_STATUS = "migrationStepStatus";

    public void report(String var1, Object var2);

    public static void reportRegistrationStatus(Object obj) {
        FrameworkStatusReporter.doReport(REGISTRATION_STATUS, obj);
    }

    public static void reportConsumptionStatus(Object obj) {
        FrameworkStatusReporter.doReport(ADDRESS_CONSUMPTION_STATUS, obj);
    }

    public static void reportMigrationStepStatus(Object obj) {
        FrameworkStatusReporter.doReport(MIGRATION_STEP_STATUS, obj);
    }

    public static boolean hasReporter() {
        return ExtensionLoader.getExtensionLoader(FrameworkStatusReporter.class).getSupportedExtensions().size() > 0;
    }

    public static void doReport(String type, Object obj) {
        try {
            Set<FrameworkStatusReporter> reporters = ExtensionLoader.getExtensionLoader(FrameworkStatusReporter.class).getSupportedExtensionInstances();
            if (CollectionUtils.isNotEmpty(reporters)) {
                FrameworkStatusReporter reporter = reporters.iterator().next();
                reporter.report(type, obj);
            }
        }
        catch (Exception e) {
            logger.info("Report " + type + " status failed because of " + e.getMessage());
        }
    }

    public static String createRegistrationReport(String status) {
        return "{\"application\":\"" + ApplicationModel.getName() + "\",\"status\":\"" + status + "\"}";
    }

    public static String createConsumptionReport(String interfaceName, String version, String group, String status) {
        HashMap<String, String> migrationStatus = new HashMap<String, String>();
        migrationStatus.put("type", ADDRESS_CONSUMPTION_STATUS);
        migrationStatus.put("application", ApplicationModel.getName());
        migrationStatus.put("service", interfaceName);
        migrationStatus.put("version", version);
        migrationStatus.put("group", group);
        migrationStatus.put("status", status);
        return gson.toJson(migrationStatus);
    }

    public static String createMigrationStepReport(String interfaceName, String version, String group, String originStep, String newStep, String success) {
        HashMap<String, String> migrationStatus = new HashMap<String, String>();
        migrationStatus.put("type", MIGRATION_STEP_STATUS);
        migrationStatus.put("application", ApplicationModel.getName());
        migrationStatus.put("service", interfaceName);
        migrationStatus.put("version", version);
        migrationStatus.put("group", group);
        migrationStatus.put("originStep", originStep);
        migrationStatus.put("newStep", newStep);
        migrationStatus.put("success", success);
        return gson.toJson(migrationStatus);
    }
}

