/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.support;

import java.util.Comparator;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.SPI;

public class WrapperComparator
implements Comparator<Object> {
    public static final Comparator<Object> COMPARATOR = new WrapperComparator();

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        Class clazz1 = (Class)o1;
        Class clazz2 = (Class)o2;
        Class<?> inf = this.findSpi(clazz1);
        OrderInfo a1 = this.parseOrder(clazz1);
        OrderInfo a2 = this.parseOrder(clazz2);
        int n1 = a1 == null ? 0 : a1.order;
        int n2 = a2 == null ? 0 : a2.order;
        return n1 > n2 ? 1 : -1;
    }

    private Class<?> findSpi(Class clazz) {
        if (clazz.getInterfaces().length == 0) {
            return null;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (intf.isAnnotationPresent(SPI.class)) {
                return intf;
            }
            Class<?> result = this.findSpi(intf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private OrderInfo parseOrder(Class<?> clazz) {
        OrderInfo info = new OrderInfo();
        if (clazz.isAnnotationPresent(Activate.class)) {
            Activate activate = clazz.getAnnotation(Activate.class);
            info.order = activate.order();
        } else if (clazz.isAnnotationPresent(com.alibaba.dubbo.common.extension.Activate.class)) {
            com.alibaba.dubbo.common.extension.Activate activate = clazz.getAnnotation(com.alibaba.dubbo.common.extension.Activate.class);
            info.order = activate.order();
        }
        return info;
    }

    private static class OrderInfo {
        private int order;

        private OrderInfo() {
        }
    }
}

