/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import com.alibaba.dubbo.config.annotation.Service;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;

public class ServiceAnnotationResolver {
    public static List<Class<? extends Annotation>> SERVICE_ANNOTATION_CLASSES = Collections.unmodifiableList(Arrays.asList(DubboService.class, org.apache.dubbo.config.annotation.Service.class, Service.class));
    private final Annotation serviceAnnotation;
    private final Class<?> serviceType;

    public ServiceAnnotationResolver(Class<?> serviceType) throws IllegalArgumentException {
        this.serviceType = serviceType;
        this.serviceAnnotation = this.getServiceAnnotation(serviceType);
    }

    private Annotation getServiceAnnotation(Class<?> serviceType) {
        Class<? extends Annotation> serviceAnnotationClass;
        Annotation serviceAnnotation = null;
        Iterator<Class<? extends Annotation>> iterator = SERVICE_ANNOTATION_CLASSES.iterator();
        while (iterator.hasNext() && (serviceAnnotation = serviceType.getAnnotation(serviceAnnotationClass = iterator.next())) == null) {
        }
        if (serviceAnnotation == null) {
            throw new IllegalArgumentException(String.format("Any annotation of [%s] can't be annotated in the service type[%s].", SERVICE_ANNOTATION_CLASSES, serviceType.getName()));
        }
        return serviceAnnotation;
    }

    public String resolveInterfaceClassName() {
        Object[] interfaces;
        Class<?> interfaceClass = null;
        String interfaceName = (String)this.resolveAttribute("interfaceName");
        interfaceClass = StringUtils.isEmpty(interfaceName) ? (Class<?>)this.resolveAttribute("interfaceClass") : ClassUtils.resolveClass(interfaceName, this.getClass().getClassLoader());
        interfaceName = ClassUtils.isGenericClass(interfaceClass) ? interfaceClass.getName() : null;
        if (StringUtils.isEmpty(interfaceName) && ArrayUtils.isNotEmpty(interfaces = this.serviceType.getInterfaces())) {
            interfaceName = ((Class)interfaces[0]).getName();
        }
        return interfaceName;
    }

    public String resolveVersion() {
        return (String)this.resolveAttribute("version");
    }

    public String resolveGroup() {
        return (String)this.resolveAttribute("group");
    }

    private <T> T resolveAttribute(String attributeName) {
        return AnnotationUtils.getAttribute(this.serviceAnnotation, attributeName);
    }

    public Annotation getServiceAnnotation() {
        return this.serviceAnnotation;
    }

    public Class<?> getServiceType() {
        return this.serviceType;
    }
}

