/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.status.support;

import java.util.Map;
import org.apache.dubbo.common.status.Status;

public class StatusUtils {
    public static Status getSummaryStatus(Map<String, Status> statuses) {
        Status.Level level = Status.Level.OK;
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, Status> entry : statuses.entrySet()) {
            String key = entry.getKey();
            Status status = entry.getValue();
            Status.Level l = status.getLevel();
            if (Status.Level.ERROR.equals((Object)l)) {
                level = Status.Level.ERROR;
                if (msg.length() > 0) {
                    msg.append(",");
                }
                msg.append(key);
                continue;
            }
            if (!Status.Level.WARN.equals((Object)l)) continue;
            if (!Status.Level.ERROR.equals((Object)level)) {
                level = Status.Level.WARN;
            }
            if (msg.length() > 0) {
                msg.append(",");
            }
            msg.append(key);
        }
        return new Status(level, msg.toString());
    }
}

