/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.convert.Converter;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class URL
implements Serializable {
    private static final long serialVersionUID = -1985165475234910535L;
    protected String protocol;
    protected String username;
    protected String password;
    protected String host;
    protected int port;
    protected String path;
    private final Map<String, String> parameters;
    private final Map<String, Map<String, String>> methodParameters;
    private volatile transient Map<String, Number> numbers;
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private volatile transient Map<String, URL> urls;
    private volatile transient String ip;
    private volatile transient String full;
    private volatile transient String identity;
    private volatile transient String parameter;
    private volatile transient String string;
    private transient String serviceKey;
    private transient String protocolServiceKey;
    private transient String address;

    protected URL() {
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.address = null;
        this.path = null;
        this.parameters = null;
        this.methodParameters = null;
    }

    public URL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String username, String password, String host, int port, String path, String ... pairs) {
        this(protocol, username, password, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, username, password, host, port, path, parameters, URL.toMethodParameters(parameters));
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Map<String, String>> methodParameters) {
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = Math.max(port, 0);
        this.address = URL.getAddress(this.host, this.port);
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
        this.methodParameters = Collections.unmodifiableMap(methodParameters);
    }

    private static String getAddress(String host, int port) {
        return port <= 0 ? host : host + ':' + port;
    }

    public static URL valueOf(String url) {
        int poundIndex;
        if (url == null || (url = url.trim()).length() == 0) {
            throw new IllegalArgumentException("url == null");
        }
        String protocol = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int i = url.indexOf(63);
        if (i >= 0) {
            String[] parts = url.substring(i + 1).split("&");
            parameters = new HashMap<String, String>();
            for (String part : parts) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    String key = part.substring(0, j);
                    String value = part.substring(j + 1);
                    parameters.put(key, value);
                    if (!key.startsWith("default.")) continue;
                    parameters.putIfAbsent(key.substring("default.".length()), value);
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((poundIndex = url.indexOf(35)) != -1) {
            url = url.substring(0, poundIndex);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf(47);
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.lastIndexOf(64)) >= 0) {
            username = url.substring(0, i);
            int j = username.indexOf(58);
            if (j >= 0) {
                password = username.substring(j + 1);
                username = username.substring(0, j);
            }
            url = url.substring(i + 1);
        }
        if ((i = url.lastIndexOf(58)) >= 0 && i < url.length() - 1 && url.lastIndexOf(37) <= i) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return new URL(protocol, username, password, host, port, path, parameters);
    }

    public static Map<String, Map<String, String>> toMethodParameters(Map<String, String> parameters) {
        HashMap<String, Map<String, String>> methodParameters = new HashMap<String, Map<String, String>>();
        if (parameters == null) {
            return methodParameters;
        }
        String methodsString = parameters.get("methods");
        if (StringUtils.isNotEmpty(methodsString)) {
            List<String> methods = StringUtils.splitToList(methodsString, ',');
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                for (int i = 0; i < methods.size(); ++i) {
                    String method = methods.get(i);
                    int methodLen = method.length();
                    if (key.length() <= methodLen || !key.startsWith(method) || key.charAt(methodLen) != '.') continue;
                    String realKey = key.substring(methodLen + 1);
                    URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
                }
            }
        } else {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                int methodSeparator = key.indexOf(46);
                if (methodSeparator <= 0) continue;
                String method = key.substring(0, methodSeparator);
                String realKey = key.substring(methodSeparator + 1);
                URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
            }
        }
        return methodParameters;
    }

    public static URL valueOf(String url, String ... reserveParams) {
        URL result = URL.valueOf(url);
        if (reserveParams == null || reserveParams.length == 0) {
            return result;
        }
        HashMap<String, String> newMap = new HashMap<String, String>(reserveParams.length);
        Map<String, String> oldMap = result.getParameters();
        for (String reserveParam : reserveParams) {
            String tmp = oldMap.get(reserveParam);
            if (!StringUtils.isNotEmpty(tmp)) continue;
            newMap.put(reserveParam, tmp);
        }
        return result.clearParameters().addParameters(newMap);
    }

    public static URL valueOf(URL url, String[] reserveParams, String[] reserveParamPrefixs) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Map<String, String> oldMap = url.getParameters();
        if (reserveParamPrefixs != null && reserveParamPrefixs.length != 0) {
            for (Map.Entry entry : oldMap.entrySet()) {
                for (String reserveParamPrefix : reserveParamPrefixs) {
                    if (!((String)entry.getKey()).startsWith(reserveParamPrefix) || !StringUtils.isNotEmpty((String)entry.getValue())) continue;
                    newMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        if (reserveParams != null) {
            for (String reserveParam : reserveParams) {
                String tmp = oldMap.get(reserveParam);
                if (!StringUtils.isNotEmpty(tmp)) continue;
                newMap.put(reserveParam, tmp);
            }
        }
        return newMap.isEmpty() ? new URL(url.getProtocol(), url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath()) : new URL(url.getProtocol(), url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), url.getPath(), newMap);
    }

    public static String encode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static String appendDefaultPort(String address, int defaultPort) {
        if (address != null && address.length() > 0 && defaultPort > 0) {
            int i = address.indexOf(58);
            if (i < 0) {
                return address + ":" + defaultPort;
            }
            if (Integer.parseInt(address.substring(i + 1)) == 0) {
                return address.substring(0, i + 1) + defaultPort;
            }
        }
        return address;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public URL setProtocol(String protocol) {
        return new URL(protocol, this.username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public String getUsername() {
        return this.username;
    }

    public URL setUsername(String username) {
        return new URL(this.getProtocol(), username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public String getPassword() {
        return this.password;
    }

    public URL setPassword(String password) {
        return new URL(this.getProtocol(), this.username, password, this.host, this.port, this.path, this.getParameters());
    }

    public String getAuthority() {
        if (StringUtils.isEmpty(this.username) && StringUtils.isEmpty(this.password)) {
            return null;
        }
        return (this.username == null ? "" : this.username) + ":" + (this.password == null ? "" : this.password);
    }

    public String getHost() {
        return this.host;
    }

    public URL setHost(String host) {
        return new URL(this.getProtocol(), this.username, this.password, host, this.port, this.path, this.getParameters());
    }

    public String getIp() {
        if (this.ip == null) {
            this.ip = NetUtils.getIpByHost(this.host);
        }
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public URL setPort(int port) {
        return new URL(this.getProtocol(), this.username, this.password, this.host, port, this.path, this.getParameters());
    }

    public int getPort(int defaultPort) {
        return this.port <= 0 ? defaultPort : this.port;
    }

    public String getAddress() {
        if (this.address == null) {
            this.address = URL.getAddress(this.host, this.port);
        }
        return this.address;
    }

    public URL setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        return new URL(this.getProtocol(), this.username, this.password, host, port, this.path, this.getParameters());
    }

    public String getBackupAddress() {
        return this.getBackupAddress(0);
    }

    public String getBackupAddress(int defaultPort) {
        StringBuilder address = new StringBuilder(URL.appendDefaultPort(this.getAddress(), defaultPort));
        Object[] backups = this.getParameter("backup", new String[0]);
        if (ArrayUtils.isNotEmpty(backups)) {
            for (Object backup : backups) {
                address.append(',');
                address.append(URL.appendDefaultPort((String)backup, defaultPort));
            }
        }
        return address.toString();
    }

    public List<URL> getBackupUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this);
        String[] backups = this.getParameter("backup", new String[0]);
        if (backups != null && backups.length > 0) {
            for (String backup : backups) {
                urls.add(this.setAddress(backup));
            }
        }
        return urls;
    }

    public String getPath() {
        return this.path;
    }

    public URL setPath(String path) {
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, path, this.getParameters());
    }

    public String getAbsolutePath() {
        if (this.path != null && !this.path.startsWith("/")) {
            return "/" + this.path;
        }
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getParameters(Predicate<String> nameToSelect) {
        LinkedHashMap<String, String> selectedParameters = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getParameters().entrySet()) {
            String name = entry.getKey();
            if (!nameToSelect.test(name)) continue;
            selectedParameters.put(name, entry.getValue());
        }
        return Collections.unmodifiableMap(selectedParameters);
    }

    public <T> T getParameter(String key, Class<T> valueType) {
        return this.getParameter(key, valueType, null);
    }

    public <T> T getParameter(String key, Class<T> valueType, T defaultValue) {
        String value = this.getParameter(key);
        T result = null;
        if (!StringUtils.isBlank(value)) {
            result = Converter.convertIfPossible(value, valueType);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public Map<String, Map<String, String>> getMethodParameters() {
        return this.methodParameters;
    }

    public String getParameterAndDecoded(String key) {
        return this.getParameterAndDecoded(key, null);
    }

    public String getParameterAndDecoded(String key, String defaultValue) {
        return URL.decode(this.getParameter(key, defaultValue));
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : CommonConstants.COMMA_SPLIT_PATTERN.split(value);
    }

    public List<String> getParameter(String key, List<String> defaultValue) {
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        String[] strArray = CommonConstants.COMMA_SPLIT_PATTERN.split(value);
        return Arrays.asList(strArray);
    }

    protected Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    protected Map<String, Map<String, Number>> getMethodNumbers() {
        if (this.methodNumbers == null) {
            this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
        }
        return this.methodNumbers;
    }

    private Map<String, URL> getUrls() {
        if (this.urls == null) {
            this.urls = new ConcurrentHashMap<String, URL>();
        }
        return this.urls;
    }

    public URL getUrlParameter(String key) {
        URL u = this.getUrls().get(key);
        if (u != null) {
            return u;
        }
        String value = this.getParameterAndDecoded(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        u = URL.valueOf(value);
        this.getUrls().put(key, u);
        return u;
    }

    public double getParameter(String key, double defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getParameter(String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getParameter(String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public int getParameter(String key, int defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    public short getParameter(String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getParameter(String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public float getPositiveParameter(String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getParameter(key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public double getPositiveParameter(String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getParameter(key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public long getPositiveParameter(String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getParameter(key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getPositiveParameter(String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getPositiveParameter(String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getPositiveParameter(String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getParameter(key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public char getParameter(String key, char defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public String getMethodParameterAndDecoded(String method, String key) {
        return URL.decode(this.getMethodParameter(method, key));
    }

    public String getMethodParameterAndDecoded(String method, String key, String defaultValue) {
        return URL.decode(this.getMethodParameter(method, key, defaultValue));
    }

    public String getMethodParameterStrict(String method, String key) {
        Map<String, String> keyMap = this.getMethodParameters().get(method);
        String value = null;
        if (keyMap != null) {
            value = keyMap.get(key);
        }
        return value;
    }

    public String getMethodParameter(String method, String key) {
        Map<String, String> keyMap = this.getMethodParameters().get(method);
        String value = null;
        if (keyMap != null) {
            value = keyMap.get(key);
        }
        if (StringUtils.isEmpty(value)) {
            value = this.parameters.get(key);
        }
        return value;
    }

    public String getMethodParameter(String method, String key, String defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public double getMethodParameter(String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    public float getMethodParameter(String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    public long getMethodParameter(String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    public int getMethodParameter(String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    public short getMethodParameter(String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    public byte getMethodParameter(String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    private Number getCachedNumber(String method, String key) {
        Map<String, Number> keyNumber = this.getMethodNumbers().get(method);
        if (keyNumber != null) {
            return keyNumber.get(key);
        }
        return null;
    }

    private void updateCachedNumber(String method, String key, Number n) {
        Map keyNumber = this.getMethodNumbers().computeIfAbsent(method, m -> new HashMap());
        keyNumber.put(key, n);
    }

    public double getMethodPositiveParameter(String method, String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public float getMethodPositiveParameter(String method, String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public long getMethodPositiveParameter(String method, String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getMethodPositiveParameter(String method, String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getMethodPositiveParameter(String method, String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getMethodPositiveParameter(String method, String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getMethodParameter(method, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public char getMethodParameter(String method, String key, char defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getMethodParameter(String method, String key, boolean defaultValue) {
        String value = this.getMethodParameter(method, key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameterStrict(method, key);
        return StringUtils.isNotEmpty(value);
    }

    public boolean hasMethodParameter(String method) {
        if (method == null) {
            return false;
        }
        return this.getMethodParameters().containsKey(method);
    }

    public boolean isLocalHost() {
        return NetUtils.isLocalHost(this.host) || this.getParameter("localhost", false);
    }

    public boolean isAnyHost() {
        return "0.0.0.0".equals(this.host) || this.getParameter("anyhost", false);
    }

    public URL addParameterAndEncoded(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.addParameter(key, URL.encode(value));
    }

    public URL addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, char value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, byte value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, short value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, int value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, long value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, float value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, double value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (value.equals(this.getParameters().get(key))) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL addMethodParameter(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(method + "." + key, value);
        Map<String, Map<String, String>> methodMap = URL.toMethodParameters(map);
        URL.putMethodParameter(method, key, value, methodMap);
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map, methodMap);
    }

    public URL addMethodParameterIfAbsent(String method, String key, String value) {
        if (StringUtils.isEmpty(method) || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.hasMethodParameter(method, key)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(method + "." + key, value);
        Map<String, Map<String, String>> methodMap = URL.toMethodParameters(map);
        URL.putMethodParameter(method, key, value, methodMap);
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map, methodMap);
    }

    public URL addParameters(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        boolean hasAndEqual = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = this.getParameters().get(entry.getKey());
            if (value == null) {
                if (entry.getValue() == null) continue;
                hasAndEqual = false;
                break;
            }
            if (value.equals(entry.getValue())) continue;
            hasAndEqual = false;
            break;
        }
        if (hasAndEqual) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.putAll(parameters);
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL addParametersIfAbsent(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(parameters);
        map.putAll(this.getParameters());
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL addParameters(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Map pairs can not be odd number.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int len = pairs.length / 2;
        for (int i = 0; i < len; ++i) {
            map.put(pairs[2 * i], pairs[2 * i + 1]);
        }
        return this.addParameters(map);
    }

    public URL addParameterString(String query) {
        if (StringUtils.isEmpty(query)) {
            return this;
        }
        return this.addParameters(StringUtils.parseQueryString(query));
    }

    public URL removeParameter(String key) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        return this.removeParameters(key);
    }

    public URL removeParameters(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    public URL removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        for (String key : keys) {
            map.remove(key);
        }
        if (map.size() == this.getParameters().size()) {
            return this;
        }
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL clearParameters() {
        return new URL(this.getProtocol(), this.username, this.password, this.host, this.port, this.path, new HashMap<String, String>());
    }

    public String getRawParameter(String key) {
        if ("protocol".equals(key)) {
            return this.protocol;
        }
        if ("username".equals(key)) {
            return this.username;
        }
        if ("password".equals(key)) {
            return this.password;
        }
        if ("host".equals(key)) {
            return this.host;
        }
        if ("port".equals(key)) {
            return String.valueOf(this.port);
        }
        if ("path".equals(key)) {
            return this.path;
        }
        return this.getParameter(key);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map;
        HashMap<String, String> hashMap = map = null == this.parameters ? new HashMap<String, String>() : new HashMap<String, String>(this.parameters);
        if (this.protocol != null) {
            map.put("protocol", this.protocol);
        }
        if (this.username != null) {
            map.put("username", this.username);
        }
        if (this.password != null) {
            map.put("password", this.password);
        }
        if (this.host != null) {
            map.put("host", this.host);
        }
        if (this.port > 0) {
            map.put("port", String.valueOf(this.port));
        }
        if (this.path != null) {
            map.put("path", this.path);
        }
        return map;
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = this.buildString(false, true, new String[0]);
        return this.string;
    }

    public String toString(String ... parameters) {
        return this.buildString(false, true, parameters);
    }

    public String toIdentityString() {
        if (this.identity != null) {
            return this.identity;
        }
        this.identity = this.buildString(true, false, new String[0]);
        return this.identity;
    }

    public String toIdentityString(String ... parameters) {
        return this.buildString(true, false, parameters);
    }

    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = this.buildString(true, true, new String[0]);
        return this.full;
    }

    public String toFullString(String ... parameters) {
        return this.buildString(true, true, parameters);
    }

    public String toParameterString() {
        if (this.parameter != null) {
            return this.parameter;
        }
        this.parameter = this.toParameterString(new String[0]);
        return this.parameter;
    }

    public String toParameterString(String ... parameters) {
        StringBuilder buf = new StringBuilder();
        this.buildParameters(buf, false, parameters);
        return buf.toString();
    }

    private void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (CollectionUtils.isNotEmptyMap(this.getParameters())) {
            List<String> includes = ArrayUtils.isEmpty(parameters) ? null : Arrays.asList(parameters);
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (!StringUtils.isNotEmpty(entry.getKey()) || includes != null && !includes.contains(entry.getKey())) continue;
                if (first) {
                    if (concat) {
                        buf.append("?");
                    }
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String path;
        String host;
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.protocol)) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if (appendUser && StringUtils.isNotEmpty(this.username)) {
            buf.append(this.username);
            if (StringUtils.isNotEmpty(this.password)) {
                buf.append(":");
                buf.append(this.password);
            }
            buf.append("@");
        }
        if (StringUtils.isNotEmpty(host = useIP ? this.getIp() : this.getHost())) {
            buf.append(host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if (StringUtils.isNotEmpty(path = useService ? this.getServiceKey() : this.getPath())) {
            buf.append("/");
            buf.append(path);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    public java.net.URL toJavaURL() {
        try {
            return new java.net.URL(this.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getColonSeparatedKey() {
        StringBuilder serviceNameBuilder = new StringBuilder();
        serviceNameBuilder.append(this.getServiceInterface());
        this.append(serviceNameBuilder, "version", false);
        this.append(serviceNameBuilder, "group", false);
        return serviceNameBuilder.toString();
    }

    private void append(StringBuilder target, String parameterName, boolean first) {
        String parameterValue = this.getParameter(parameterName);
        if (!StringUtils.isBlank(parameterValue)) {
            if (!first) {
                target.append(":");
            }
            target.append(parameterValue);
        } else {
            target.append(":");
        }
    }

    public String getServiceKey() {
        if (this.serviceKey != null) {
            return this.serviceKey;
        }
        String inf = this.getServiceInterface();
        if (inf == null) {
            return null;
        }
        this.serviceKey = URL.buildKey(inf, this.getParameter("group"), this.getParameter("version"));
        return this.serviceKey;
    }

    public String getPathKey() {
        String inf;
        String string = inf = StringUtils.isNotEmpty(this.path) ? this.path : this.getServiceInterface();
        if (inf == null) {
            return null;
        }
        return URL.buildKey(inf, this.getParameter("group"), this.getParameter("version"));
    }

    public static String buildKey(String path, String group, String version) {
        return BaseServiceMetadata.buildServiceKey(path, group, version);
    }

    public String getProtocolServiceKey() {
        if (this.protocolServiceKey != null) {
            return this.protocolServiceKey;
        }
        this.protocolServiceKey = this.getServiceKey() + ":" + this.getProtocol();
        return this.protocolServiceKey;
    }

    public String toServiceStringWithoutResolving() {
        return this.buildString(true, false, false, true, new String[0]);
    }

    public String toServiceString() {
        return this.buildString(true, false, true, true, new String[0]);
    }

    @Deprecated
    public String getServiceName() {
        return this.getServiceInterface();
    }

    public String getServiceInterface() {
        return this.getParameter("interface", this.path);
    }

    public URL setServiceInterface(String service) {
        return this.addParameter("interface", service);
    }

    @Deprecated
    public int getIntParameter(String key) {
        return this.getParameter(key, 0);
    }

    @Deprecated
    public int getIntParameter(String key, int defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    @Deprecated
    public int getPositiveIntParameter(String key, int defaultValue) {
        return this.getPositiveParameter(key, defaultValue);
    }

    @Deprecated
    public boolean getBooleanParameter(String key) {
        return this.getParameter(key, false);
    }

    @Deprecated
    public boolean getBooleanParameter(String key, boolean defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    @Deprecated
    public int getMethodIntParameter(String method, String key) {
        return this.getMethodParameter(method, key, 0);
    }

    @Deprecated
    public int getMethodIntParameter(String method, String key, int defaultValue) {
        return this.getMethodParameter(method, key, defaultValue);
    }

    @Deprecated
    public int getMethodPositiveIntParameter(String method, String key, int defaultValue) {
        return this.getMethodPositiveParameter(method, key, defaultValue);
    }

    @Deprecated
    public boolean getMethodBooleanParameter(String method, String key) {
        return this.getMethodParameter(method, key, false);
    }

    @Deprecated
    public boolean getMethodBooleanParameter(String method, String key, boolean defaultValue) {
        return this.getMethodParameter(method, key, defaultValue);
    }

    public Configuration toConfiguration() {
        InmemoryConfiguration configuration = new InmemoryConfiguration();
        configuration.addProperties(this.parameters);
        return configuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parametersHashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URL other = (URL)obj;
        if (!StringUtils.isEquals(this.host, other.host)) {
            return false;
        }
        if (this.parameters == null) {
            if (other.parameters != null) {
                return false;
            }
        } else {
            if (!this.parameters.keySet().equals(other.parameters.keySet())) {
                return false;
            }
            for (String key : this.parameters.keySet()) {
                if (key.equals("timestamp") || this.parameters.get(key).equals(other.parameters.get(key))) continue;
                return false;
            }
        }
        if (!StringUtils.isEquals(this.password, other.password)) {
            return false;
        }
        if (!StringUtils.isEquals(this.path, other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!StringUtils.isEquals(this.protocol, other.protocol)) {
            return false;
        }
        return StringUtils.isEquals(this.username, other.username);
    }

    private int parametersHashCode() {
        int h = 0;
        for (Map.Entry<String, String> next : this.parameters.entrySet()) {
            if ("timestamp".equals(next.getKey())) continue;
            h += next.hashCode();
        }
        return h;
    }

    public static void putMethodParameter(String method, String key, String value, Map<String, Map<String, String>> methodParameters) {
        Map subParameter = methodParameters.computeIfAbsent(method, k -> new HashMap());
        subParameter.put(key, value);
    }

    public Map<String, String> getServiceParameters(String service) {
        return this.getParameters();
    }

    public String getServiceParameter(String service, String key) {
        return this.getParameter(key);
    }

    public String getServiceParameter(String service, String key, String defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public int getServiceParameter(String service, String key, int defaultValue) {
        return this.getParameter(key, defaultValue);
    }

    public double getServiceParameter(String service, String key, double defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getServiceParameter(String service, String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getServiceParameter(String service, String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public short getServiceParameter(String service, String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getServiceParameter(String service, String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public char getServiceParameter(String service, String key, char defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : value.charAt(0);
    }

    public boolean getServiceParameter(String service, String key, boolean defaultValue) {
        String value = this.getServiceParameter(service, key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean hasServiceParameter(String service, String key) {
        String value = this.getServiceParameter(service, key);
        return value != null && value.length() > 0;
    }

    public float getPositiveServiceParameter(String service, String key, float defaultValue) {
        if (defaultValue <= 0.0f) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        float value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0.0f ? defaultValue : value;
    }

    public double getPositiveServiceParameter(String service, String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0.0 ? defaultValue : value;
    }

    public long getPositiveServiceParameter(String service, String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0L ? defaultValue : value;
    }

    public int getPositiveServiceParameter(String service, String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public short getPositiveServiceParameter(String service, String key, short defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        short value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public byte getPositiveServiceParameter(String service, String key, byte defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        byte value = this.getServiceParameter(service, key, defaultValue);
        return value <= 0 ? defaultValue : value;
    }

    public String getServiceMethodParameterAndDecoded(String service, String method, String key) {
        return URL.decode(this.getServiceMethodParameter(service, method, key));
    }

    public String getServiceMethodParameterAndDecoded(String service, String method, String key, String defaultValue) {
        return URL.decode(this.getServiceMethodParameter(service, method, key, defaultValue));
    }

    public String getServiceMethodParameterStrict(String service, String method, String key) {
        return this.getMethodParameterStrict(method, key);
    }

    public String getServiceMethodParameter(String service, String method, String key) {
        return this.getMethodParameter(method, key);
    }

    public String getServiceMethodParameter(String service, String method, String key, String defaultValue) {
        String value = this.getServiceMethodParameter(service, method, key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public double getServiceMethodParameter(String service, String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    public float getServiceMethodParameter(String service, String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    public long getServiceMethodParameter(String service, String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    public int getServiceMethodParameter(String service, String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    public short getMethodParameter(String service, String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    public byte getServiceMethodParameter(String service, String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    public boolean hasServiceMethodParameter(String service, String method, String key) {
        return this.hasMethodParameter(method, key);
    }

    public boolean hasServiceMethodParameter(String service, String method) {
        return this.hasMethodParameter(method);
    }

    protected Map<String, Number> getServiceNumbers(String service) {
        return this.getNumbers();
    }

    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String service) {
        return this.getMethodNumbers();
    }
}

